/**
 * @file FwBoschRegistryWrapper.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Bosch registry handling.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Bosch registry handling. Wrapper to avoid Bosch OSAL specific includes. Wrapper shall be used in application code.
 */

#ifndef _FW_BOSCH_REGISTRY_WRAPPER_H_
#define _FW_BOSCH_REGISTRY_WRAPPER_H_

#include <string>

namespace fw {

// class forward declarations
class BoschRegistry;

/**
 *
 */
class BoschRegistryWrapper
{
public:
   /**
    * Default constructor.
    */
   BoschRegistryWrapper();

   /**
    * Destructor.
    */
   virtual ~BoschRegistryWrapper();

   /**
    * Open registry.
    *
    * @param[in] registryPath: registry path
    */
   void open(const ::std::string& registryPath);

   /**
    * Close registry.
    */
   void close(void);

   /**
    * Write registry entry.
    *
    * @param[in] key: key
    * @param[in] value: value
    */
   void write(const ::std::string& key, const ::std::string& value) const;

   /**
    * Read registry entry.
    *
    * @param[out] value: value
    * @param[in] key: key
    *
    * @return = true: reading success, false: reading failed
    */
   bool read(::std::string& value, const ::std::string& key) const;

private:
   /**
    * Copy constructor.
    *
    * DO NOT USE!!!
    *
    * @param[in] ref: reference of message to be copied
    */
   BoschRegistryWrapper(const BoschRegistryWrapper& ref);

   /**
    * Assignment operator.
    *
    * DO NOT USE!!!
    *
    * @param[in] ref: reference of message to be assigned
    */
   BoschRegistryWrapper& operator=(const BoschRegistryWrapper& ref);

   BoschRegistry* _registry; /**< registry item */
};

} //fw

#endif //_FW_BOSCH_REGISTRY_WRAPPER_H_
