/**
 * @file FwAssert.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Assert definition.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Assert macros are defined here.
 */

#ifndef _FW_ASSERT_H_
#define _FW_ASSERT_H_

#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#if OSAL_OS == OSAL_LINUX
// no include necessary
#else // OSAL_OS == OSAL_LINUX
#include <cstdio>
#endif // OSAL_OS == OSAL_LINUX
#else // VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include <cstdio>
#ifndef VARIANT_S_FTR_ENABLE_ASSERT_REPLACEMENT
#include <cassert>
#endif
#endif // VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

#define FW_IF_NULL_PTR_RETURN(a) if(0 == a) { FW_NORMAL_ASSERT_ALWAYS(); return; }
#define FW_IF_NULL_PTR_RETURN_FALSE(a) if(0 == a) { FW_NORMAL_ASSERT_ALWAYS(); return false; }
#define FW_IF_NULL_PTR_RETURN_TRUE(a) if(0 == a) { FW_NORMAL_ASSERT_ALWAYS(); return true; }
#define FW_IF_NULL_PTR_RETURN_NULL(a) if(0 == a) { FW_NORMAL_ASSERT_ALWAYS(); return 0; }
#define FW_IF_NULL_PTR_RETURN_ERROR(a, e) if(0 == a) { FW_NORMAL_ASSERT_ALWAYS(); return e; }

#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

#if OSAL_OS == OSAL_LINUX

namespace fw {

void AssertFunction(const char* exp, const char* file, const unsigned int line);

} //fw

// for next part check: \ai_osal_common\components\osal\include\osansi.h
#ifndef FATAL_M_ASSERT
#define FATAL_M_ASSERT(_INT_) ((_INT_) ? (void)(0) : (::fw::AssertFunction(#_INT_, __FILE__, (__LINE__)&(~0x80000000))) )
#endif

#ifndef FATAL_M_ASSERT_ALWAYS
#define FATAL_M_ASSERT_ALWAYS() ((::fw::AssertFunction("ALWAYS", __FILE__, (__LINE__)&(~0x80000000))) )
#endif

#ifndef NORMAL_M_ASSERT
#define NORMAL_M_ASSERT(_INT_) ((_INT_) ? (void)(0) : (::fw::AssertFunction(#_INT_, __FILE__, (__LINE__)|0x80000000)) )
#endif

#ifndef NORMAL_M_ASSERT_ALWAYS
#define NORMAL_M_ASSERT_ALWAYS() ((::fw::AssertFunction("ALWAYS", __FILE__, (__LINE__)|0x80000000)) )
#endif

#define FW_FATAL_ASSERT FATAL_M_ASSERT
#define FW_FATAL_ASSERT_ALWAYS FATAL_M_ASSERT_ALWAYS
#define FW_NORMAL_ASSERT NORMAL_M_ASSERT
#define FW_NORMAL_ASSERT_ALWAYS NORMAL_M_ASSERT_ALWAYS

#else // OSAL_OS == OSAL_LINUX

#define FW_FATAL_ASSERT(a)  if(!(a)) { printf(" ********** FATAL ASSERT @ Function=%s, Line=%d, File=[%s]: "#a,__FUNCTION__,__LINE__,__FILE__); printf("\n"); }
#define FW_FATAL_ASSERT_ALWAYS()  { printf(" ********** FATAL ASSERT @ Function=%s, Line=%d, File=[%s]: ALWAYS",__FUNCTION__,__LINE__,__FILE__); printf("\n"); }
#define FW_NORMAL_ASSERT(a)  if(!(a)) { printf(" ********** NORMAL ASSERT @ Function=%s, Line=%d, File=[%s]: "#a,__FUNCTION__,__LINE__,__FILE__); printf("\n"); }
#define FW_NORMAL_ASSERT_ALWAYS()  { printf(" ********** NORMAL ASSERT @ Function=%s, Line=%d, File=[%s]: ALWAYS",__FUNCTION__,__LINE__,__FILE__); printf("\n"); }

#endif // OSAL_OS == OSAL_LINUX

#else // VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

#ifdef VARIANT_S_FTR_ENABLE_ASSERT_REPLACEMENT // google test reuses assert for its own purpose; source code within assert will not be executed in this case
#define FW_FATAL_ASSERT(a)  if(!(a)) { fprintf(stderr, " ********** FATAL ASSERT @ Function=%s, Line=%d, File=[%s]: "#a,__FUNCTION__,__LINE__,__FILE__); fprintf(stderr, "\n"); }
#define FW_FATAL_ASSERT_ALWAYS() { fprintf(stderr, " ********** FATAL ASSERT @ Function=%s, Line=%d, File=[%s]: ALWAYS",__FUNCTION__,__LINE__,__FILE__); fprintf(stderr, "\n"); }
#else // VARIANT_S_FTR_ENABLE_ASSERT_REPLACEMENT
#define FW_FATAL_ASSERT assert
#define FW_FATAL_ASSERT_ALWAYS() assert(0)
#endif // VARIANT_S_FTR_ENABLE_ASSERT_REPLACEMENT
#define FW_NORMAL_ASSERT(a) if(!(a)) { fprintf(stderr, " ********** NORMAL ASSERT @ Function=%s, Line=%d, File=[%s]: "#a,__FUNCTION__,__LINE__,__FILE__); fprintf(stderr, "\n"); }
#define FW_NORMAL_ASSERT_ALWAYS() { fprintf(stderr, " ********** NORMAL ASSERT @ Function=%s, Line=%d, File=[%s]: ALWAYS",__FUNCTION__,__LINE__,__FILE__); fprintf(stderr, "\n"); }

#endif // VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

#endif //_FW_ASSERT_H_
