#include "cc/proxies/only/CcDbusIfComponent.h"
#include "IReceiveLocalEventMessage.h"
#include "FwSemaphore.h"

using namespace ::asf::core;

namespace cc {
namespace proxies {
namespace only {

::ccdbusif::IReceiveLocalEventMessage* CcDbusIfComponent::_eventReceiver = 0;
::ccdbusif::ISendLocalEventMessage* CcDbusIfComponent::_eventSender = 0;
::fw::Semaphore* CcDbusIfComponent::_startupSem = 0;

CcDbusIfComponent::CcDbusIfComponent() :
BaseComponent(),
LocalMessageCallbackIF1< unsigned int >()
{
   _eventSender = this;
   if(_startupSem)
   {
      _startupSem->post();
   }
}

CcDbusIfComponent::~CcDbusIfComponent()
{
   _eventReceiver = 0;
   _eventSender = 0;
   _startupSem = 0;
}

void CcDbusIfComponent::onLocalMessage(::boost::shared_ptr< PayloadTuple1< unsigned int > >& data)
{
   if(_eventReceiver)
   {
      _eventReceiver->handleReceiveLocalEvent(data->get0());
   }
}

void CcDbusIfComponent::handleSendLocalEvent(const unsigned int event)
{
   sendLocalMessage< unsigned int >(*this, event);
}

void CcDbusIfComponent::setEventReceiver(::ccdbusif::IReceiveLocalEventMessage* receiver)
{
   _eventReceiver = receiver;
}

void CcDbusIfComponent::setStartupSemaphore(::fw::Semaphore* semaphore)
{
   _startupSem = semaphore;
}

::ccdbusif::ISendLocalEventMessage* CcDbusIfComponent::getEventSender(void)
{
   if(_startupSem)
   {
      _startupSem->wait();
   }
   return _eventSender;
}

} //only
} //proxies
} //cc
