#ifndef _CC_DBUS_IF_COMPONENT_PROXIES_ONLY_H_
#define _CC_DBUS_IF_COMPONENT_PROXIES_ONLY_H_

#include "asf/core/BaseComponent.h"
#include "asf/core/LocalMessage.h"
#include "ISendLocalEventMessage.h"

using namespace ::asf::core;

namespace ccdbusif {
class IReceiveLocalEventMessage;
} //ccdbusif

namespace fw {
class Semaphore;
} //fw

namespace cc {
namespace proxies {
namespace only {

class CcDbusIfComponent :
         public BaseComponent,
         public LocalMessageCallbackIF1< unsigned int >,
         public ::ccdbusif::ISendLocalEventMessage
{
public:
   CcDbusIfComponent();

   virtual ~CcDbusIfComponent();

   virtual void onLocalMessage(::boost::shared_ptr< PayloadTuple1< unsigned int > >& data);

   virtual void handleSendLocalEvent(const unsigned int event);

   static void setEventReceiver(::ccdbusif::IReceiveLocalEventMessage* receiver);

   static void setStartupSemaphore(::fw::Semaphore* semaphore);

   static ::ccdbusif::ISendLocalEventMessage* getEventSender(void);

private:
   static ::ccdbusif::IReceiveLocalEventMessage* _eventReceiver;
   static ::ccdbusif::ISendLocalEventMessage* _eventSender;
   static ::fw::Semaphore* _startupSem;
};

} //only
} //proxies
} //cc

#endif //_CC_DBUS_IF_COMPONENT_PROXIES_ONLY_H_
