/**
 * @file WblDbusLastIntendedModeProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl DBUS Properties for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl DBUS Properties for LastIntendedMode.
 */

#include "WblDbusLastIntendedModeProperties.h"

namespace ccdbusif {
namespace wbl {

WblDbusLastIntendedModeProperties::WblDbusLastIntendedModeProperties() :
DbusProperties("LastIntendedMode"),
_propertyLastIntendedMode("LastIntendedMode"),
_propertyAPConfig("APConfig"),
_propertyPowerState("PowerState"),
_propertyWifiMode("WifiMode"),
_propertyFrequency("Frequency"),
_propertyType("Type"),
_propertySPITechnologies("SPITechnologies"),
_propertyCarPlayWireless("CarPlayWireless"),
_propertyAndroidAutoWireless("AndroidAutoWireless"),
_propertyConnectionStatus("ConnectionStatus"),
_propertyConnected("Connected"),
_propertyHealthIndicator("HealthIndicator"),
_statePoweringOn("WIFI_STATE_POWERING_ON"),
_statePoweredOn("WIFI_STATE_POWERED_ON"),
_statePoweringOff("WIFI_STATE_POWERING_OFF"),
_statePoweredOff("WIFI_STATE_POWERED_OFF"),
_statePowerFailure("WIFI_STATE_POWER_FAILURE"),
_stateDeviceUnavailable("WIFI_STATE_DEVICE_UNAVAILABLE"),
_stateDeviceAvailable("WIFI_STATE_DEVICE_AVAILABLE"),
_stateUnknown(""),
_modeSTA("STA"),
_modeAP("AP"),
_modeP2P("P2P"),
_modeALL("ALL"),
_frequency2_4_GHz("2.4 GHz"),
_frequency5_GHz("5 GHz"),
_typeCarPlayWireless("CarPlayWireless"),
_typeAndroidAutoWireless("AndroidAutoWireless"),
_typeNormal("Normal"),
_typeRestricted("Restricted"),
_typeUnknown("Unknown"),
_settingNotAllowed("NOT_ALLOWED"),
_settingAllowed("ALLOWED"),
_settingAllowedWithLimitations("ALLOWED_WITH_LIMITATIONS"),
_state2EnumList(),
_enum2StateList(),
_mode2EnumList(),
_enum2ModeList(),
_frequency2EnumList(),
_enum2FrequencyList(),
_type2EnumList(),
_enum2TypeList(),
_setting2EnumList(),
_enum2SettingList()
{
   _string2EnumList[_propertyLastIntendedMode] = (int)LAST_INTENDED_MODE_LASTINTENDEDMODE;
   _string2EnumList[_propertyAPConfig] = (int)LAST_INTENDED_MODE_APCONFIG;
   _string2EnumList[_propertyPowerState] = (int)LAST_INTENDED_MODE_POWERSTATE;
   _string2EnumList[_propertyWifiMode] = (int)LAST_INTENDED_MODE_WIFIMODE;
   _string2EnumList[_propertyFrequency] = (int)LAST_INTENDED_MODE_FREQUENCY;
   _string2EnumList[_propertyType] = (int)LAST_INTENDED_MODE_TYPE;
   _string2EnumList[_propertySPITechnologies] = (int)LAST_INTENDED_MODE_SPITECHNOLOGIES;
   _string2EnumList[_propertyCarPlayWireless] = (int)LAST_INTENDED_MODE_CARPLAYWIRELESS;
   _string2EnumList[_propertyAndroidAutoWireless] = (int)LAST_INTENDED_MODE_ANDROIDAUTOWIRELESS;
   _string2EnumList[_propertyConnectionStatus] = (int)LAST_INTENDED_MODE_CONNECTION_STATUS;
   _string2EnumList[_propertyConnected] = (int)LAST_INTENDED_MODE_CONNECTED;
   _string2EnumList[_propertyHealthIndicator] = (int)LAST_INTENDED_MODE_HEALTH_INDICATOR;

   _enum2StringList[(int)LAST_INTENDED_MODE_LASTINTENDEDMODE] = &_propertyLastIntendedMode;
   _enum2StringList[(int)LAST_INTENDED_MODE_APCONFIG] = &_propertyAPConfig;
   _enum2StringList[(int)LAST_INTENDED_MODE_POWERSTATE] = &_propertyPowerState;
   _enum2StringList[(int)LAST_INTENDED_MODE_WIFIMODE] = &_propertyWifiMode;
   _enum2StringList[(int)LAST_INTENDED_MODE_FREQUENCY] = &_propertyFrequency;
   _enum2StringList[(int)LAST_INTENDED_MODE_TYPE] = &_propertyType;
   _enum2StringList[(int)LAST_INTENDED_MODE_SPITECHNOLOGIES] = &_propertySPITechnologies;
   _enum2StringList[(int)LAST_INTENDED_MODE_CARPLAYWIRELESS] = &_propertyCarPlayWireless;
   _enum2StringList[(int)LAST_INTENDED_MODE_ANDROIDAUTOWIRELESS] = &_propertyAndroidAutoWireless;
   _enum2StringList[(int)LAST_INTENDED_MODE_CONNECTION_STATUS] = &_propertyConnectionStatus;
   _enum2StringList[(int)LAST_INTENDED_MODE_CONNECTED] = &_propertyConnected;
   _enum2StringList[(int)LAST_INTENDED_MODE_HEALTH_INDICATOR] = &_propertyHealthIndicator;

   _state2EnumList[_statePoweringOn] = (int)POWER_STATE_POWERING_ON;
   _state2EnumList[_statePoweredOn] = (int)POWER_STATE_POWERED_ON;
   _state2EnumList[_statePoweringOff] = (int)POWER_STATE_POWERING_OFF;
   _state2EnumList[_statePoweredOff] = (int)POWER_STATE_POWERED_OFF;
   _state2EnumList[_statePowerFailure] = (int)POWER_STATE_POWER_FAILURE;
   _state2EnumList[_stateDeviceUnavailable] = (int)POWER_STATE_DEVICE_UNAVAILABLE;
   _state2EnumList[_stateDeviceAvailable] = (int)POWER_STATE_DEVICE_AVAILABLE;
   _state2EnumList[_stateUnknown] = (int)POWER_STATE_DEVICE_UNAVAILABLE;

   _enum2StateList[(int)POWER_STATE_POWERING_ON] = &_statePoweringOn;
   _enum2StateList[(int)POWER_STATE_POWERED_ON] = &_statePoweredOn;
   _enum2StateList[(int)POWER_STATE_POWERING_OFF] = &_statePoweringOff;
   _enum2StateList[(int)POWER_STATE_POWERED_OFF] = &_statePoweredOff;
   _enum2StateList[(int)POWER_STATE_POWER_FAILURE] = &_statePowerFailure;
   _enum2StateList[(int)POWER_STATE_DEVICE_UNAVAILABLE] = &_stateDeviceUnavailable;
   _enum2StateList[(int)POWER_STATE_DEVICE_AVAILABLE] = &_stateDeviceAvailable;

   _mode2EnumList[_modeSTA] = (int)WIFI_MODE_STA;
   _mode2EnumList[_modeAP] = (int)WIFI_MODE_AP;
   _mode2EnumList[_modeP2P] = (int)WIFI_MODE_P2P;
   _mode2EnumList[_modeALL] = (int)WIFI_MODE_ALL;

   _enum2ModeList[(int)WIFI_MODE_STA] = &_modeSTA;
   _enum2ModeList[(int)WIFI_MODE_AP] = &_modeAP;
   _enum2ModeList[(int)WIFI_MODE_P2P] = &_modeP2P;
   _enum2ModeList[(int)WIFI_MODE_ALL] = &_modeALL;

   _frequency2EnumList[_frequency2_4_GHz] = (int)WIFI_FREQUENCY_2_4_GHZ;
   _frequency2EnumList[_frequency5_GHz] = (int)WIFI_FREQUENCY_5_GHZ;

   _enum2FrequencyList[(int)WIFI_FREQUENCY_2_4_GHZ] = &_frequency2_4_GHz;
   _enum2FrequencyList[(int)WIFI_FREQUENCY_5_GHZ] = &_frequency5_GHz;

   _type2EnumList[_typeCarPlayWireless] = (int)WIFI_TYPE_CARPLAYWIRELESS;
   _type2EnumList[_typeAndroidAutoWireless] = (int)WIFI_TYPE_ANDROIDAUTOWIRELESS;
   _type2EnumList[_typeNormal] = (int)WIFI_TYPE_NORMAL;
   _type2EnumList[_typeRestricted] = (int)WIFI_TYPE_RESTRICTED;
   _type2EnumList[_typeUnknown] = (int)WIFI_TYPE_TYPE_UNKNOWN;

   _enum2TypeList[(int)WIFI_TYPE_CARPLAYWIRELESS] = &_typeCarPlayWireless;
   _enum2TypeList[(int)WIFI_TYPE_ANDROIDAUTOWIRELESS] = &_typeAndroidAutoWireless;
   _enum2TypeList[(int)WIFI_TYPE_NORMAL] = &_typeNormal;
   _enum2TypeList[(int)WIFI_TYPE_RESTRICTED] = &_typeRestricted;
   _enum2TypeList[(int)WIFI_TYPE_TYPE_UNKNOWN] = &_typeUnknown;

   _setting2EnumList[_settingNotAllowed] = (int)SUPPORTED_SETTING_NOT_ALLOWED;
   _setting2EnumList[_settingAllowed] = (int)SUPPORTED_SETTING_ALLOWED;
   _setting2EnumList[_settingAllowedWithLimitations] = (int)SUPPORTED_SETTING_ALLOWED_WITH_LIMITATIONS;

   _enum2SettingList[(int)SUPPORTED_SETTING_NOT_ALLOWED] = &_settingNotAllowed;
   _enum2SettingList[(int)SUPPORTED_SETTING_ALLOWED] = &_settingAllowed;
   _enum2SettingList[(int)SUPPORTED_SETTING_ALLOWED_WITH_LIMITATIONS] = &_settingAllowedWithLimitations;
}

WblDbusLastIntendedModeProperties::~WblDbusLastIntendedModeProperties()
{
}

LastIntendedModeProperty WblDbusLastIntendedModeProperties::getProperty2Enum(const ::std::string& value) const
{
   return (LastIntendedModeProperty)convertString2Enum(value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getProperty2String(const LastIntendedModeProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getProperty2StringTrace(const LastIntendedModeProperty value) const
{
   if(LAST_INTENDED_MODE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

PowerState WblDbusLastIntendedModeProperties::getPowerState2Enum(const ::std::string& value) const
{
   return (PowerState)convertString2Enum(_state2EnumList, value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getPowerState2String(const PowerState value) const
{
   return convertEnum2String(_enum2StateList, (const int)value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getPowerState2StringTrace(const PowerState value) const
{
   if(POWER_STATE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2StateList, (const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

WiFiMode WblDbusLastIntendedModeProperties::getWiFiMode2Enum(const ::std::string& value) const
{
   return (WiFiMode)convertString2Enum(_mode2EnumList, value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getWiFiMode2String(const WiFiMode value) const
{
   return convertEnum2String(_enum2ModeList, (const int)value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getWiFiMode2StringTrace(const WiFiMode value) const
{
   if(WIFI_MODE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2ModeList, (const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

WiFiFrequency WblDbusLastIntendedModeProperties::getWiFiFrequency2Enum(const ::std::string& value) const
{
   return (WiFiFrequency)convertString2Enum(_frequency2EnumList, value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getWiFiFrequency2String(const WiFiFrequency value) const
{
   return convertEnum2String(_enum2FrequencyList, (const int)value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getWiFiFrequency2StringTrace(const WiFiFrequency value) const
{
   if(WIFI_FREQUENCY_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2FrequencyList, (const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

WiFiType WblDbusLastIntendedModeProperties::getWiFiType2Enum(const ::std::string& value) const
{
   return (WiFiType)convertString2Enum(_type2EnumList, value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getWiFiType2String(const WiFiType value) const
{
   return convertEnum2String(_enum2TypeList, (const int)value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getWiFiType2StringTrace(const WiFiType value) const
{
   if(WIFI_TYPE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2TypeList, (const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

SupportedSetting WblDbusLastIntendedModeProperties::getSupportedSetting2Enum(const ::std::string& value) const
{
   return (SupportedSetting)convertString2Enum(_setting2EnumList, value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getSupportedSetting2String(const SupportedSetting value) const
{
   return convertEnum2String(_enum2SettingList, (const int)value);
}

const ::std::string& WblDbusLastIntendedModeProperties::getSupportedSetting2StringTrace(const SupportedSetting value) const
{
   if(SUPPORTED_SETTING_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2SettingList, (const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //wbl
} //ccdbusif
