/**
 * @file WblDbusLastIntendedModeFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl instance factory for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl instance factory for LastIntendedMode.
 */

#include "WblDbusLastIntendedModeFactory.h"
#include "WblDbusLastIntendedModeProxyIf.h"

namespace ccdbusif {
namespace wbl {

WblDbusLastIntendedModeFactory::WblDbusLastIntendedModeFactory() :
_proxy(0),
_testProxy(0)
{
}

WblDbusLastIntendedModeFactory::~WblDbusLastIntendedModeFactory()
{
   _proxy = 0;
   _testProxy = 0;
}

WblDbusLastIntendedModeFactory& WblDbusLastIntendedModeFactory::getInstance(void)
{
   static WblDbusLastIntendedModeFactory factory;
   return factory;
}

IWblDbusLastIntendedModeSendRequestIf* WblDbusLastIntendedModeFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(0 != _proxy)
   {
      // already created
   }
   else
   {
      _proxy = new WblDbusLastIntendedModeProxyIf(client, _testProxy);
   }

   return _proxy;
}

void WblDbusLastIntendedModeFactory::destroyProxy(void)
{
   if(0 != _proxy)
   {
      delete _proxy;
      _proxy = 0;
   }
}

void WblDbusLastIntendedModeFactory::setProxyForTesting(IWblDbusLastIntendedModeTestProxyIf* testProxy)
{
   _testProxy = testProxy;
}

} //wbl
} //ccdbusif
