/**
 * @file WblDbusTypes.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief WBL DBUS Types.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details WBL DBUS Types.
 */

#ifndef _WBL_DBUS_TYPES_H_
#define _WBL_DBUS_TYPES_H_

namespace ccdbusif {
namespace wbl {

/**
 * Type definition for interfaces.
 */
enum Interface
{
   IF_LAST_INTENDED_MODE = 0,
   IF_CONFLICT_MANAGEMENT,
   IF_WIFI_SETUP,
   // -------------------------------------------------------------------------
   IF_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for LastIntendedMode properties.
 */
enum LastIntendedModeProperty
{
   LAST_INTENDED_MODE_LASTINTENDEDMODE = 0,
   LAST_INTENDED_MODE_APCONFIG,
   LAST_INTENDED_MODE_POWERSTATE,
   LAST_INTENDED_MODE_WIFIMODE,
   LAST_INTENDED_MODE_FREQUENCY,
   LAST_INTENDED_MODE_TYPE,
   LAST_INTENDED_MODE_SPITECHNOLOGIES,
   LAST_INTENDED_MODE_CARPLAYWIRELESS,
   LAST_INTENDED_MODE_ANDROIDAUTOWIRELESS,
   LAST_INTENDED_MODE_CONNECTION_STATUS,
   LAST_INTENDED_MODE_CONNECTED,
   LAST_INTENDED_MODE_HEALTH_INDICATOR,
   // -------------------------------------------------------------------------
   LAST_INTENDED_MODE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for Power state.
 */
enum PowerState
{
   POWER_STATE_POWERING_ON = 0,
   POWER_STATE_POWERED_ON,
   POWER_STATE_POWERING_OFF,
   POWER_STATE_POWERED_OFF,
   POWER_STATE_POWER_FAILURE,
   POWER_STATE_DEVICE_UNAVAILABLE,
   POWER_STATE_DEVICE_AVAILABLE,
   // -------------------------------------------------------------------------
   POWER_STATE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for WiFi mode.
 */
enum WiFiMode
{
   WIFI_MODE_STA = 0,
   WIFI_MODE_AP,
   WIFI_MODE_P2P,
   WIFI_MODE_ALL,
   // -------------------------------------------------------------------------
   WIFI_MODE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for WiFi frequency.
 */
enum WiFiFrequency
{
   WIFI_FREQUENCY_2_4_GHZ = 0,
   WIFI_FREQUENCY_5_GHZ,
   // -------------------------------------------------------------------------
   WIFI_FREQUENCY_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for WiFi type.
 */
enum WiFiType
{
   WIFI_TYPE_CARPLAYWIRELESS = 0,
   WIFI_TYPE_ANDROIDAUTOWIRELESS,
   WIFI_TYPE_NORMAL,
   WIFI_TYPE_RESTRICTED,
   WIFI_TYPE_TYPE_UNKNOWN,
   // -------------------------------------------------------------------------
   WIFI_TYPE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for supported setting.
 */
enum SupportedSetting
{
   SUPPORTED_SETTING_NOT_ALLOWED = 0,
   SUPPORTED_SETTING_ALLOWED,
   SUPPORTED_SETTING_ALLOWED_WITH_LIMITATIONS,
   // -------------------------------------------------------------------------
   SUPPORTED_SETTING_UNKNOWN /**< end marker, must be the last one */
};

} //wbl
} //ccdbusif

#endif //_WBL_DBUS_TYPES_H_
