/**
 * @file WblDbusLastIntendedModeProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl DBUS proxy for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl DBUS proxy for LastIntendedMode.
 */

#ifndef _WBL_DBUS_LAST_INTENDED_MODE_PROXY_IF_H_
#define _WBL_DBUS_LAST_INTENDED_MODE_PROXY_IF_H_

#include "ISetCallback.h"
#include "ICreateProxy.h"
#include "IDestroyProxy.h"
#include "IDestroyAllProxies.h"
#include "IWblDbusLastIntendedModeSendRequestIf.h"
#include "IWblDbusLastIntendedModeCallbackIf.h"
#include "IWblDbusLastIntendedModeTestProxyIf.h"
#include "DbusBaseProxyIf.h"

#include "asf/core/Proxy.h" // ServiceAvailableIF
#include "org/bosch/wbl/LastIntendedModeProxy.h"

using namespace ::asf::core;
using namespace ::org::bosch::wbl::LastIntendedMode;

namespace ccdbusif {
namespace wbl {

/**
 * LastIntendedMode proxy class for Wbl interface.
 */
class WblDbusLastIntendedModeProxyIf :
   public ServiceAvailableIF,
   public ISetCallback< IWblDbusLastIntendedModeCallbackIf >,
   public ICreateProxy,
   public IDestroyProxy,
   public IDestroyAllProxies,
   public IWblDbusLastIntendedModeSendRequestIf,
   public LastIntendedModeCallbackIF,
   public IWblDbusLastIntendedModeCallbackIf,
   public DbusBaseProxyIf< IWblDbusLastIntendedModeCallbackIf, LastIntendedModeProxy, IWblDbusLastIntendedModeTestProxyIf >
{
public:
   WblDbusLastIntendedModeProxyIf(ICcDbusIfControllerClient* client);

   WblDbusLastIntendedModeProxyIf(ICcDbusIfControllerClient* client, IWblDbusLastIntendedModeTestProxyIf* testProxyIf);

   virtual ~WblDbusLastIntendedModeProxyIf();

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);

   virtual void onUnavailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   virtual void handleSetCallback(IWblDbusLastIntendedModeCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleCreateProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyAllProxies(void);

   virtual void handleDestroyAllRuntimeProxies(void);

   // IWblDbusLastIntendedModeSendRequestIf implementation --- start
   virtual IDestroyAllProxies* getDestroyer(void);

   virtual void setCallbackIf(IWblDbusLastIntendedModeCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void createProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void destroyProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual act_t sendLastIntendedModeGet(const unsigned int callbackId);
   // IWblDbusLastIntendedModeSendRequestIf implementation --- end

   // CallbackIF implementation --- start
   virtual void onLastIntendedModeError(const ::boost::shared_ptr< LastIntendedModeProxy >& proxy, const ::boost::shared_ptr< LastIntendedModeError >& error);

   virtual void onLastIntendedModeUpdate(const ::boost::shared_ptr< LastIntendedModeProxy >& proxy, const ::boost::shared_ptr< LastIntendedModeUpdate >& update);
   // CallbackIF implementation --- end

   // IWblDbusLastIntendedModeCallbackIf implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onLastIntendedModeErrorCb(const ::boost::shared_ptr< LastIntendedModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onLastIntendedModeUpdateCb(const ::boost::shared_ptr< LastIntendedModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
   // IWblDbusLastIntendedModeCallbackIf implementation --- end

protected:
   virtual void internalCreateProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyAllProxies(void);

   virtual void internalDestroyAllRuntimeProxies(void);

   void internalOnAvailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   void internalOnUnavailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);
};

} //wbl
} //ccdbusif

#endif //_WBL_DBUS_LAST_INTENDED_MODE_PROXY_IF_H_
