/**
 * @file WblDbusInterfaces.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief WBL DBUS Interfaces.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details WBL DBUS Interfaces.
 */

#ifndef _WBL_DBUS_INTERFACES_H_
#define _WBL_DBUS_INTERFACES_H_

#include "IDbusProperty2EnumMapping.h"
#include "WblDbusTypes.h"
#include "WblDbusLastIntendedModeProperties.h"
#include "WblDbusConflictManagementProperties.h"
#include "WblDbusWifiSetupProperties.h"

namespace ccdbusif {
namespace wbl {

/**
 * Class for WBL interfaces.
 */
class WblDbusInterfaces : public IDbusProperty2EnumMapping
{
public:
   WblDbusInterfaces();
   virtual ~WblDbusInterfaces();

   virtual void getInterfaces(::std::vector<const ::std::map< std::string, int >*>& interfaceList, const ::std::vector< int >& matchingInterfaces) const;

   const ::std::string& getRootObjectPath(void) const;

   const ::std::string& getInterface2Name(const Interface value) const;
   const ::std::string& getInterface2ObjectPath(const Interface value) const;
   const ::std::string& getInterface2BusName(const Interface value) const;
   DbusBusType getInterface2BusType(const Interface value) const;
   const ::std::string& getInterface2Port(const Interface value) const;

   inline LastIntendedModeProperty getLastIntendedModeProperty2Enum(const ::std::string& value) const { return (LastIntendedModeProperty)_propertiesLastIntendedMode.convertString2Enum(value); }
   inline const ::std::string& getLastIntendedModeProperty2String(const LastIntendedModeProperty value) const { return _propertiesLastIntendedMode.convertEnum2String((int)value); }

   inline PowerState getPowerState2Enum(const ::std::string& value) const { return _propertiesLastIntendedMode.getPowerState2Enum(value); }
   inline const ::std::string& getPowerState2String(const PowerState value) const { return _propertiesLastIntendedMode.getPowerState2String(value); }

   inline WiFiMode getWiFiMode2Enum(const ::std::string& value) const { return _propertiesLastIntendedMode.getWiFiMode2Enum(value); }
   inline const ::std::string& getWiFiMode2String(const WiFiMode value) const { return _propertiesLastIntendedMode.getWiFiMode2String(value); }

   inline WiFiFrequency getWiFiFrequency2Enum(const ::std::string& value) const { return _propertiesLastIntendedMode.getWiFiFrequency2Enum(value); }
   inline const ::std::string& getWiFiFrequency2String(const WiFiFrequency value) const { return _propertiesLastIntendedMode.getWiFiFrequency2String(value); }

   inline WiFiType getWiFiType2Enum(const ::std::string& value) const { return _propertiesLastIntendedMode.getWiFiType2Enum(value); }
   inline const ::std::string& getWiFiType2String(const WiFiType value) const { return _propertiesLastIntendedMode.getWiFiType2String(value); }

   inline SupportedSetting getSupportedSetting2Enum(const ::std::string& value) const { return _propertiesLastIntendedMode.getSupportedSetting2Enum(value); }
   inline const ::std::string& getSupportedSetting2String(const SupportedSetting value) const { return _propertiesLastIntendedMode.getSupportedSetting2String(value); }

private:
   const ::std::string _dummy;

   const ::std::string _objPathRoot;

   const ::std::string _interfaceLastIntendedMode;
   const ::std::string _interfaceConflictManagement;
   const ::std::string _interfaceWifiSetup;

   const ::std::string _objPathLastIntendedMode;
   const ::std::string _objPathConflictManagement;
   const ::std::string _objPathWifiSetup;

   const ::std::string _busNameLastIntendedMode;
   const ::std::string _busNameConflictManagement;
   const ::std::string _busNameWifiSetup;

   const DbusBusType _busTypeLastIntendedMode;
   const DbusBusType _busTypeConflictManagement;
   const DbusBusType _busTypeWifiSetup;

   const ::std::string _portLastIntendedMode;
   const ::std::string _portConflictManagement;
   const ::std::string _portWifiSetup;

   WblDbusLastIntendedModeProperties _propertiesLastIntendedMode;
   WblDbusConflictManagementProperties _propertiesConflictManagement;
   WblDbusWifiSetupProperties _propertiesWifiSetup;
};

} //wbl
} //ccdbusif

#endif //_WBL_DBUS_INTERFACES_H_
