/**
 * @file IWblDbusLastIntendedModeTestProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl DBUS Test Proxy Interface for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for Wbl DBUS test proxy for LastIntendedMode.
 */

#ifndef _I_WBL_DBUS_LAST_INTENDED_MODE_TEST_PROXY_IF_H_
#define _I_WBL_DBUS_LAST_INTENDED_MODE_TEST_PROXY_IF_H_

#include "CcDbusIfTypes.h"
#include <boost/shared_ptr.hpp>

namespace ccdbusif {

// class forward declarations
class IWblDbusLastIntendedModeCallbackIf;

/**
 * Test proxy interface class for LastIntendedMode.
 */
class IWblDbusLastIntendedModeTestProxyIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IWblDbusLastIntendedModeTestProxyIf() {}

   /**
    * Create proxy.
    *
    * @param[in] callback: callback handler
    * @param[in] port: port
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void createProxy(IWblDbusLastIntendedModeCallbackIf& callback, const ::std::string& port, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Destroy proxy.
    *
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void destroyProxy(const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Destroy all proxies.
    */
   virtual void destroyAllProxies(void) = 0;

   /**
    * Send LastIntendedMode Get.
    *
    * @param[in] callback: callback handler
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendLastIntendedModeGet(IWblDbusLastIntendedModeCallbackIf& callback) = 0;
};

} //ccdbusif

#endif //_I_WBL_DBUS_LAST_INTENDED_MODE_TEST_PROXY_IF_H_
