/**
 * @file PropertiesGetAllCreateRuntimeProxyWorkItem.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create runtime proxy work item.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Create runtime proxy work item.
 */

#include "PropertiesGetAllCreateRuntimeProxyWorkItem.h"
#include "IPropertiesGetAllCreateRuntimeProxy.h"

#include <cstddef>

namespace ccdbusif {

PropertiesGetAllCreateRuntimeProxyWorkItem::PropertiesGetAllCreateRuntimeProxyWorkItem()
{
   // _busName;
   // _objPath;
   _busType = BUS_TYPE_SYSTEM;
   _user = NULL;
   _callback = NULL;
   _proxyCreator = NULL;
}

PropertiesGetAllCreateRuntimeProxyWorkItem::PropertiesGetAllCreateRuntimeProxyWorkItem(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IPropertiesGetAllDbusCallbackIf* callback, IPropertiesGetAllCreateRuntimeProxy* creator)
{
   _busName = busName;
   _objPath = objPath;
   _busType = busType;
   _user = user;
   _callback = callback;
   _proxyCreator = creator;
}

PropertiesGetAllCreateRuntimeProxyWorkItem::~PropertiesGetAllCreateRuntimeProxyWorkItem()
{
   _user = NULL;
   _callback = NULL;
   _proxyCreator = NULL;
}

void PropertiesGetAllCreateRuntimeProxyWorkItem::processWorkItem(void)
{
   if(NULL != _proxyCreator)
   {
      _proxyCreator->createRuntimeProxy(_busName, _objPath, _busType, _user, _callback);
   }
}

} //ccdbusif
