/**
 * @file PropertiesGetAllProxyManager.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Proxy management for properties get all interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Proxy management for properties get all interface.
 */

#ifndef _PROPERTIES_GET_ALL_PROXY_MANAGER_H_
#define _PROPERTIES_GET_ALL_PROXY_MANAGER_H_

#include "ProxyManager.h"

#include "getall/org/freedesktop/DBus/PropertiesProxy.h"

using namespace ::getall::org::freedesktop::DBus::Properties;

namespace ccdbusif {

// class forward declarations
class IPropertiesGetAllDbusCallbackIf;

/**
 *
 */
class PropertiesGetAllProxyManager :
   public ProxyManager< PropertiesProxy >
{
public:
   PropertiesGetAllProxyManager();
   PropertiesGetAllProxyManager(const PropertiesGetAllProxyManager& ref);
   PropertiesGetAllProxyManager& operator=(const PropertiesGetAllProxyManager& ref);
   bool operator==(const PropertiesGetAllProxyManager& ref) const;
   bool operator!=(const PropertiesGetAllProxyManager& ref) const;
   virtual ~PropertiesGetAllProxyManager();

   void addCallbackIf(const ProxyMetaData& metaData, IPropertiesGetAllDbusCallbackIf* callback);
   void addCallbackIf(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IPropertiesGetAllDbusCallbackIf* callback);
   void removeCallbackIf(const ProxyMetaData& metaData);
   void removeCallbackIf(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user);
   IPropertiesGetAllDbusCallbackIf* getCallbackIf(const ProxyMetaData& metaData);
   IPropertiesGetAllDbusCallbackIf* getCallbackIf(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user);
   void removeAllCallbackIfs(void);

private:
   ::std::map<ProxyMetaData, IPropertiesGetAllDbusCallbackIf*> _proxyMetaData2CallbackIf;
};

} //ccdbusif

#endif //_PROPERTIES_GET_ALL_PROXY_MANAGER_H_
