/**
 * @file IPropertiesGetAllDbusCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Properties GetAll DBUS Callback Interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for Properties GetAll DBUS callbacks.
 */

#ifndef _I_PROPERTIES_GET_ALL_DBUS_CALLBACK_IF_H_
#define _I_PROPERTIES_GET_ALL_DBUS_CALLBACK_IF_H_

#include "CcDbusIfTypes.h"

#include "getall/org/freedesktop/DBus/PropertiesProxy.h"

using namespace ::getall::org::freedesktop::DBus::Properties;

using namespace ::asf::core;

namespace ccdbusif {

/**
 *
 */
class IPropertiesGetAllDbusCallbackIf :
   // from PropertiesProxy.h --- start
   public GetAllCallbackIF
   // from PropertiesProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IPropertiesGetAllDbusCallbackIf() {}

   // HINT: these interfaces are called within context of thread defined in CcDbusIfAppLibrary.cma ("ccDbusIfThread")

   // "ServiceAvailableIF" implementation --- start
   virtual void onPropertiesGetAllProxyAvailable(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, const ServiceState previousState, const ServiceState currentState) = 0;
   virtual void onPropertiesGetAllProxyUnavailable(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, const ServiceState previousState, const ServiceState currentState) = 0;
   // "ServiceAvailableIF" implementation --- end

   // PropertiesProxy implementation --- start
   // HINT: proxy object delivers following data:
   //    const std::string& getDBusBusName() const;
   //    const std::string& getDBusObjectPath() const;
   //    const std::string& getInterfaceName() const;
   //    DbusBusType getBusType() const;
   virtual void onGetAllError(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< GetAllError >& error) = 0;
   virtual void onGetAllResponse(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< GetAllResponse >& response) = 0;
   // PropertiesProxy implementation --- end
};

} //ccdbusif

#endif //_I_PROPERTIES_GET_ALL_DBUS_CALLBACK_IF_H_
