/**
 * @file IPropertiesGetAllCreateRuntimeProxy.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create Proxy for properties get all interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Create proxy for CcDbusIf for properties get all interface.
 */

#ifndef _I_PROPERTIES_GET_ALL_CREATE_RUNTIME_PROXY_H_
#define _I_PROPERTIES_GET_ALL_CREATE_RUNTIME_PROXY_H_

#include "CcDbusIfTypes.h"

namespace ccdbusif {

// class forward declarations
class IPropertiesGetAllDbusCallbackIf;

/**
 *
 */
class IPropertiesGetAllCreateRuntimeProxy
{
public:
   /**
    * Destructor.
    */
   virtual ~IPropertiesGetAllCreateRuntimeProxy() {}

   /**
    * Create proxy.
    *
    * @param[in] busName: bus name
    * @param[in] objPath: object path
    * @param[in] busType: bus type
    * @param[in] user: user
    * @param[in] callbackIf: callback handler
    */
   virtual void createRuntimeProxy(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IPropertiesGetAllDbusCallbackIf* callbackIf) = 0;
};

} //ccdbusif

#endif //_I_PROPERTIES_GET_ALL_CREATE_RUNTIME_PROXY_H_
