/**
 * @file OrgFreedesktopDbusObjectManagerFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief OrgFreedesktop instance factory for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details OrgFreedesktop instance factory for ObjectManager.
 */

#include "OrgFreedesktopDbusObjectManagerFactory.h"
#include "OrgFreedesktopDbusObjectManagerProxyIf.h"

namespace ccdbusif {
namespace freedesktop {

OrgFreedesktopDbusObjectManagerFactory::OrgFreedesktopDbusObjectManagerFactory() :
_proxy(0),
_testProxy(0)
{
}

OrgFreedesktopDbusObjectManagerFactory::~OrgFreedesktopDbusObjectManagerFactory()
{
   _proxy = 0;
   _testProxy = 0;
}

OrgFreedesktopDbusObjectManagerFactory& OrgFreedesktopDbusObjectManagerFactory::getInstance(void)
{
   static OrgFreedesktopDbusObjectManagerFactory factory;
   return factory;
}

IOrgFreedesktopDbusObjectManagerSendRequestIf* OrgFreedesktopDbusObjectManagerFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(0 != _proxy)
   {
      // already created
   }
   else
   {
      _proxy = new OrgFreedesktopDbusObjectManagerProxyIf(client, _testProxy);
   }

   return _proxy;
}

void OrgFreedesktopDbusObjectManagerFactory::destroyProxy(void)
{
   if(0 != _proxy)
   {
      delete _proxy;
      _proxy = 0;
   }
}

void OrgFreedesktopDbusObjectManagerFactory::setProxyForTesting(IOrgFreedesktopDbusObjectManagerTestProxyIf* testProxy)
{
   _testProxy = testProxy;
}

} //freedesktop
} //ccdbusif
