/**
 * @file IOrgFreedesktopDbusObjectManagerTestProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief OrgFreedesktop DBUS Test Proxy Interface for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for OrgFreedesktop DBUS test proxy for ObjectManager.
 */

#ifndef _I_ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_TEST_PROXY_IF_H_
#define _I_ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_TEST_PROXY_IF_H_

#include "CcDbusIfTypes.h"
#include <boost/shared_ptr.hpp>

namespace ccdbusif {

// class forward declarations
class IOrgFreedesktopDbusObjectManagerCallbackIf;

/**
 * Test proxy interface class for ObjectManager.
 */
class IOrgFreedesktopDbusObjectManagerTestProxyIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IOrgFreedesktopDbusObjectManagerTestProxyIf() {}

   /**
    * Create proxy.
    *
    * @param[in] callback: callback handler
    * @param[in] port: port
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void createProxy(IOrgFreedesktopDbusObjectManagerCallbackIf& callback, const ::std::string& port, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Destroy proxy.
    *
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void destroyProxy(const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Destroy all proxies.
    */
   virtual void destroyAllProxies(void) = 0;

   /**
    * Send GetManagedObjects Request.
    *
    * @param[in] callback: callback handler
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendGetManagedObjectsRequest(IOrgFreedesktopDbusObjectManagerCallbackIf& callback, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType) = 0;
};

} //ccdbusif

#endif //_I_ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_TEST_PROXY_IF_H_
