/**
 * @file IntrospectableDestroyRuntimeProxyWorkItem.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Destroy runtime proxy work item.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Destroy runtime proxy work item.
 */

#include "IntrospectableDestroyRuntimeProxyWorkItem.h"
#include "IIntrospectableDestroyRuntimeProxy.h"

#include <cstddef>

namespace ccdbusif {

IntrospectableDestroyRuntimeProxyWorkItem::IntrospectableDestroyRuntimeProxyWorkItem()
{
   // _busName;
   // _objPath;
   _busType = BUS_TYPE_SYSTEM;
   _user = NULL;
   _proxyDestroyer = NULL;
}

IntrospectableDestroyRuntimeProxyWorkItem::IntrospectableDestroyRuntimeProxyWorkItem(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IIntrospectableDestroyRuntimeProxy* destroyer)
{
   _busName = busName;
   _objPath = objPath;
   _busType = busType;
   _user = user;
   _proxyDestroyer = destroyer;
}

IntrospectableDestroyRuntimeProxyWorkItem::~IntrospectableDestroyRuntimeProxyWorkItem()
{
   _user = NULL;
   _proxyDestroyer = NULL;
}

void IntrospectableDestroyRuntimeProxyWorkItem::processWorkItem(void)
{
   if(NULL != _proxyDestroyer)
   {
      _proxyDestroyer->destroyRuntimeProxy(_busName, _objPath, _busType, _user);
   }
}

} //ccdbusif
