/**
 * @file IntrospectableCreateRuntimeProxyWorkItem.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create proxy work item for introspectable interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Create proxy work item for introspectable interface.
 */

#ifndef _INTROSPECTABLE_CREATE_RUNTIME_PROXY_ITEM_H_
#define _INTROSPECTABLE_CREATE_RUNTIME_PROXY_ITEM_H_

#include "IWorkItem.h"
#include "CcDbusIfTypes.h"

namespace ccdbusif {

// class forward declarations
class IIntrospectableDbusCallbackIf;
class IIntrospectableCreateRuntimeProxy;

/**
 *
 */
class IntrospectableCreateRuntimeProxyWorkItem : public IWorkItem
{
public:
   IntrospectableCreateRuntimeProxyWorkItem(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IIntrospectableDbusCallbackIf* callback, IIntrospectableCreateRuntimeProxy* creator);
   virtual ~IntrospectableCreateRuntimeProxyWorkItem();
   virtual void processWorkItem(void);

protected:
   IntrospectableCreateRuntimeProxyWorkItem();

private:
   ::std::string _busName;
   ::std::string _objPath;
   DbusBusType _busType;
   void* _user;
   IIntrospectableDbusCallbackIf* _callback;
   IIntrospectableCreateRuntimeProxy* _proxyCreator;
};

} //ccdbusif

#endif //_INTROSPECTABLE_CREATE_RUNTIME_PROXY_ITEM_H_
