/**
 * @file IIntrospectableCreateRuntimeProxy.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create Proxy for introspectable interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Create proxy for CcDbusIf for introspectable interface.
 */

#ifndef _I_INTROSPECTABLE_CREATE_RUNTIME_PROXY_H_
#define _I_INTROSPECTABLE_CREATE_RUNTIME_PROXY_H_

#include "CcDbusIfTypes.h"

namespace ccdbusif {

// class forward declarations
class IIntrospectableDbusCallbackIf;

/**
 *
 */
class IIntrospectableCreateRuntimeProxy
{
public:
   /**
    * Destructor.
    */
   virtual ~IIntrospectableCreateRuntimeProxy() {}

   /**
    * Create proxy.
    *
    * @param[in] busName: bus name
    * @param[in] objPath: object path
    * @param[in] busType: bus type
    * @param[in] user: user
    * @param[in] callbackIf: callback handler
    */
   virtual void createRuntimeProxy(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IIntrospectableDbusCallbackIf* callbackIf) = 0;
};

} //ccdbusif

#endif //_I_INTROSPECTABLE_CREATE_RUNTIME_PROXY_H_
