/**
 * @file EvolutionGeniviDbusTypes.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Types.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Types.
 */

#include "EvolutionGeniviDbusTypes.h"
#include "EvolutionGeniviDbusParser.h"

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_ASSERT
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusTypes.cpp.trc.h"
#endif
#endif

namespace ccdbusif {
namespace evolution {

void printTypeSizes(void)
{
   ETG_TRACE_USR1((" printTypeSizes(): sizeof(DbusVariantDataType)=%u", sizeof(DbusVariantDataType)));
   ETG_TRACE_USR1((" printTypeSizes(): sizeof(DbusIntVariant)=%u", sizeof(DbusIntVariant)));
   ETG_TRACE_USR1((" printTypeSizes(): sizeof(ActInfo)=%u", sizeof(ActInfo)));
   ETG_TRACE_USR1((" printTypeSizes(): sizeof(DbusVariant)=%u", sizeof(DbusVariant)));
   ETG_TRACE_USR1((" printTypeSizes(): sizeof(DbusVariantProperty)=%u", sizeof(DbusVariantProperty)));
   ETG_TRACE_USR1((" printTypeSizes(): sizeof(DbusPropertyEntry)=%u", sizeof(DbusPropertyEntry)));
   ETG_TRACE_USR1((" printTypeSizes(): sizeof(EvolutionGeniviDbusParser)=%u", sizeof(EvolutionGeniviDbusParser)));
#if 0
   [3332639020]CCDBUSIF___,TRACE_LEVEL_USER1,Function:printTypeSizes,LINE:32, printTypeSizes(): sizeof(DbusVariantDataType)=4
   [3332639020]CCDBUSIF___,TRACE_LEVEL_USER1,Function:printTypeSizes,LINE:33, printTypeSizes(): sizeof(DbusIntVariant)=8
   [3332639020]CCDBUSIF___,TRACE_LEVEL_USER1,Function:printTypeSizes,LINE:34, printTypeSizes(): sizeof(ActInfo)=16
   [3332639020]CCDBUSIF___,TRACE_LEVEL_USER1,Function:printTypeSizes,LINE:35, printTypeSizes(): sizeof(DbusVariant)=32
   [3332639020]CCDBUSIF___,TRACE_LEVEL_USER1,Function:printTypeSizes,LINE:36, printTypeSizes(): sizeof(DbusVariantProperty)=40
   [3332639020]CCDBUSIF___,TRACE_LEVEL_USER1,Function:printTypeSizes,LINE:37, printTypeSizes(): sizeof(DbusPropertyEntry)=12
   [3332639020]CCDBUSIF___,TRACE_LEVEL_USER1,Function:printTypeSizes,LINE:39, printTypeSizes(): sizeof(EvolutionGeniviDbusParser)=8
#endif
}

const char* getAdapterProperty2String(const int value)
{
   const char* result = "<Unknown>";

   switch((AdapterProperty)value)
   {
      case ADAPTER_ADDRESS:
         result = "ADDRESS";
         break;
      case ADAPTER_CLASS:
         result = "CLASS";
         break;
      case ADAPTER_ALIAS:
         result = "ALIAS";
         break;
      case ADAPTER_POWERED:
         result = "POWERED";
         break;
      case ADAPTER_DISCOVERABLE:
         result = "DISCOVERABLE";
         break;
      case ADAPTER_DISCOVERABLETIMEOUT:
         result = "DISCOVERABLETIMEOUT";
         break;
      case ADAPTER_PAIRABLE:
         result = "PAIRABLE";
         break;
      case ADAPTER_PAIRABLETIMEOUT:
         result = "PAIRABLETIMEOUT";
         break;
      case ADAPTER_DISCOVERING:
         result = "DISCOVERING";
         break;
      case ADAPTER_UUIDS:
         result = "UUIDS";
         break;
      case ADAPTER_WBSMODE:
         result = "WBSMODE";
         break;
      case ADAPTER_CONNECTABLE:
         result = "CONNECTABLE";
         break;
      case ADAPTER_HCIMODE:
         result = "HCIMODE";
         break;
      case ADAPTER_UNKNOWN:
         result = "UNKNOWN";
         break;
      default:
         break;
   }

   return result;
}

const char* getDeviceProperty2String(const int value)
{
   const char* result = "<Unknown>";

   switch((DeviceProperty)value)
   {
      case DEVICE_ADDRESS:
         result = "ADDRESS";
         break;
      case DEVICE_CLASS:
         result = "CLASS";
         break;
      case DEVICE_ICON:
         result = "ICON";
         break;
      case DEVICE_UUIDS:
         result = "UUIDS";
         break;
      case DEVICE_PAIRED:
         result = "PAIRED";
         break;
      case DEVICE_CONNECTED:
         result = "CONNECTED";
         break;
      case DEVICE_TRUSTED:
         result = "TRUSTED";
         break;
      case DEVICE_BLOCKED:
         result = "BLOCKED";
         break;
      case DEVICE_ALIAS:
         result = "ALIAS";
         break;
      case DEVICE_ADAPTER:
         result = "ADAPTER";
         break;
      case DEVICE_MODALIAS:
         result = "MODALIAS";
         break;
      case DEVICE_RSSI:
         result = "RSSI";
         break;
      case DEVICE_VENDOR:
         result = "VENDOR";
         break;
      case DEVICE_VENDORSOURCE:
         result = "VENDORSOURCE";
         break;
      case DEVICE_PRODUCT:
         result = "PRODUCT";
         break;
      case DEVICE_MAPINFO:
         result = "MAPINFO";
         break;
      case DEVICE_CONNECTEDSERVICE:
         result = "CONNECTEDSERVICE";
         break;
      case DEVICE_VERSION:
         result = "VERSION";
         break;
      case DEVICE_PBAPINFO:
         result = "PBAPINFO";
         break;
      case DEVICE_MODE:
         result = "MODE";
         break;
      case DEVICE_ROLE:
         result = "ROLE";
         break;
      case DEVICE_ENABLEAVPPAUSE:
         result = "ENABLEAVPPAUSE";
         break;
      case DEVICE_UNKNOWN:
         result = "UNKNOWN";
         break;
      default:
         break;
   }

   return result;
}

const char* getServiceProperty2String(const int value)
{
   const char* result = "<Unknown>";

   switch((ServiceProperty)value)
   {
      case SERVICE_REMOTEUUID:
         result = "REMOTEUUID";
         break;
      case SERVICE_STATE:
         result = "STATE";
         break;
      case SERVICE_DEVICE:
         result = "DEVICE";
         break;
      case SERVICE_VERSION:
         result = "VERSION";
         break;
      case SERVICE_UNKNOWN:
         result = "UNKNOWN";
         break;
      default:
         break;
   }

   return result;
}

} //evolution
} //ccdbusif
