/**
 * @file EvolutionGeniviDbusSppProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for Spp.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Spp.
 */

#include "EvolutionGeniviDbusSppProxyIf.h"
#include "IEvolutionGeniviDbusSppCallbackIf.h"
#include "CcDbusIfTypes.h"
#include "ICcDbusIfControllerClient.h"
#include "CcDbusIfCreateProxyWorkItem.h"

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

using namespace ::org::alps::evo::SPP;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusSppProxyIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

EvolutionGeniviDbusSppProxyIf::EvolutionGeniviDbusSppProxyIf()
{
   // _sppProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusSppProxyIf::EvolutionGeniviDbusSppProxyIf(ICcDbusIfControllerClient* client) : BaseDbusProxyIf(client)
{
   // _sppProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusSppProxyIf::~EvolutionGeniviDbusSppProxyIf()
{
   _callbackIf = NULL;
}

void EvolutionGeniviDbusSppProxyIf::createProxy(void)
{
   ETG_TRACE_USR3((" createProxy(): SPP"));

   if(NULL != _callbackIf)
   {
      if(true == _enableProxy)
      {
         _sppProxy = SPPProxy::createProxy("evoSppPort", *this);
      }
   }
}

void EvolutionGeniviDbusSppProxyIf::destroyProxy(void)
{
   ETG_TRACE_USR3((" destroyProxy(): SPP"));

   if(NULL != _sppProxy.get())
   {
      _sppProxy->sendDeregisterAll();
      _sppProxy.reset();
   }
}

void EvolutionGeniviDbusSppProxyIf::destroyAllRuntimeProxies(void)
{
   ETG_TRACE_USR3((" destroyAllRuntimeProxies(): SPP"));

   // nothing to do because this is a static proxy
}

void EvolutionGeniviDbusSppProxyIf::setCallbackIf(IEvolutionGeniviDbusSppCallbackIf* callbackIf, bool enableProxy)
{
   _callbackIf = callbackIf;

   if(NULL != _callbackIf)
   {
      _enableProxy = enableProxy;
   }

   // callback interface is now available => create proxy now
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfCreateProxyWorkItem(this));
   }
}

// ServiceAvailableIF implementation --- start
void EvolutionGeniviDbusSppProxyIf::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onAvailable(): SPP"));

   if((NULL != _sppProxy.get()) && (proxy == _sppProxy))
   {
      if(NULL != _callbackIf)
      {
         _sppProxy->sendBtApplSppDataCfmRegister(*_callbackIf);
         _sppProxy->sendBtApplSppDataIndRegister(*_callbackIf);
         _sppProxy->sendBtApplSppSendIndRegister(*_callbackIf);
         _sppProxy->sendBtApplSppSetUuidCfmRegister(*_callbackIf);
         _sppProxy->sendBtApplSppFlowCtrlCfmRegister(*_callbackIf);
         _sppProxy->sendBtApplSppDataSendFcIndRegister(*_callbackIf);

         _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _sppProxy->getDBusObjectPath());
      }
   }
}

void EvolutionGeniviDbusSppProxyIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onUnavailable(): SPP"));

   if((NULL != _sppProxy.get()) && (proxy == _sppProxy))
   {
      _sppProxy->sendDeregisterAll();

      if(NULL != _callbackIf)
      {
         _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _sppProxy->getDBusObjectPath());
      }
   }
}
// ServiceAvailableIF implementation --- end

// IEvolutionGeniviDbusSppProxyIf implementation --- start
act_t EvolutionGeniviDbusSppProxyIf::sendBtApplSppDataReqRequest(uint8 instance, const ::std::vector< uint8 >& data)
{
   if((NULL != _callbackIf) && (NULL != _sppProxy.get()))
   {
      return _sppProxy->sendBtApplSppDataReqRequest(*_callbackIf, instance, data);
   }
   else
   {
      return DEFAULT_ACT;
   }
}

act_t EvolutionGeniviDbusSppProxyIf::sendBtApplSppSetUuidReqRequest(uint8 instance, const ::std::vector< uint8 >& data)
{
   if((NULL != _callbackIf) && (NULL != _sppProxy.get()))
   {
      return _sppProxy->sendBtApplSppSetUuidReqRequest(*_callbackIf, instance, data);
   }
   else
   {
      return DEFAULT_ACT;
   }
}

act_t EvolutionGeniviDbusSppProxyIf::sendBtApplSppFlowCtrlReqRequest(uint8 instance, uint8 action)
{
   if((NULL != _callbackIf) && (NULL != _sppProxy.get()))
   {
      return _sppProxy->sendBtApplSppFlowCtrlReqRequest(*_callbackIf, instance, action);
   }
   else
   {
      return DEFAULT_ACT;
   }
}
// IEvolutionGeniviDbusSppProxyIf implementation --- end

} //ccdbusif
