/**
 * @file EvolutionGeniviDbusServiceProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for Service.
 */

#include "EvolutionGeniviDbusServiceProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusServiceProperties::EvolutionGeniviDbusServiceProperties() : DbusProperties("Service"),
   // properties
   _propertyRemoteUUID("RemoteUUID"),
   _propertyState("State"),
   _propertyDevice("Device"),
   _propertyVersion("Version")
{
   _string2EnumList[_propertyRemoteUUID] = (int)SERVICE_REMOTEUUID;
   _string2EnumList[_propertyState] = (int)SERVICE_STATE;
   _string2EnumList[_propertyDevice] = (int)SERVICE_DEVICE;
   _string2EnumList[_propertyVersion] = (int)SERVICE_VERSION;

   _enum2StringList[(int)SERVICE_REMOTEUUID] = &_propertyRemoteUUID;
   _enum2StringList[(int)SERVICE_STATE] = &_propertyState;
   _enum2StringList[(int)SERVICE_DEVICE] = &_propertyDevice;
   _enum2StringList[(int)SERVICE_VERSION] = &_propertyVersion;
}

EvolutionGeniviDbusServiceProperties::~EvolutionGeniviDbusServiceProperties()
{
}

ServiceProperty EvolutionGeniviDbusServiceProperties::getProperty2Enum(const ::std::string& value) const
{
   return (ServiceProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusServiceProperties::getProperty2String(const ServiceProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusServiceProperties::getProperty2StringTrace(const ServiceProperty value) const
{
   if(SERVICE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
