/**
 * @file EvolutionGeniviDbusPanProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for Pan.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Pan.
 */

#include "EvolutionGeniviDbusPanProxyIf.h"
#include "IEvolutionGeniviDbusPanCallbackIf.h"
#include "CcDbusIfTypes.h"
#include "ICcDbusIfControllerClient.h"
#include "CcDbusIfCreateProxyWorkItem.h"

using namespace ::org::alps::evo::PAN;
using namespace ::asf::core;

namespace ccdbusif {

EvolutionGeniviDbusPanProxyIf::EvolutionGeniviDbusPanProxyIf()
{
   // _panProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusPanProxyIf::EvolutionGeniviDbusPanProxyIf(ICcDbusIfControllerClient* client) : BaseDbusProxyIf(client)
{
   // _panProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusPanProxyIf::~EvolutionGeniviDbusPanProxyIf()
{
   _callbackIf = NULL;
}

void EvolutionGeniviDbusPanProxyIf::createProxy(void)
{
   if(NULL != _callbackIf)
   {
      if(true == _enableProxy)
      {
         _panProxy = PANProxy::createProxy("evoPanPort", *this);
      }
   }
}

void EvolutionGeniviDbusPanProxyIf::destroyProxy(void)
{
   if(NULL != _panProxy.get())
   {
      _panProxy->sendDeregisterAll();
      _panProxy.reset();
   }
}

void EvolutionGeniviDbusPanProxyIf::destroyAllRuntimeProxies(void)
{
   // nothing to do because this is a static proxy
}

void EvolutionGeniviDbusPanProxyIf::setCallbackIf(IEvolutionGeniviDbusPanCallbackIf* callbackIf, bool enableProxy)
{
   _callbackIf = callbackIf;

   if(NULL != _callbackIf)
   {
      _enableProxy = enableProxy;
   }

   // callback interface is now available => create proxy now
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfCreateProxyWorkItem(this));
   }
}

// ServiceAvailableIF implementation --- start
void EvolutionGeniviDbusPanProxyIf::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   if((NULL != _panProxy.get()) && (proxy == _panProxy))
   {
      if(NULL != _callbackIf)
      {
         _panProxy->sendBtApplPanSendDataCfmRegister(*_callbackIf);
         _panProxy->sendBtApplPanSendIndRegister(*_callbackIf);
         _panProxy->sendBtApplPanFilterNettypeCfmRegister(*_callbackIf);
         _panProxy->sendBtApplPanFilterNettypeIndRegister(*_callbackIf);
         _panProxy->sendBtApplPanFilterMuladdrCfmRegister(*_callbackIf);
         _panProxy->sendBtApplPanFilterMuladdrIndRegister(*_callbackIf);
         _panProxy->sendBtApplPanDataIndRegister(*_callbackIf);

         _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _panProxy->getDBusObjectPath());
      }
   }
}

void EvolutionGeniviDbusPanProxyIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   if((NULL != _panProxy.get()) && (proxy == _panProxy))
   {
      _panProxy->sendDeregisterAll();

      if(NULL != _callbackIf)
      {
         _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _panProxy->getDBusObjectPath());
      }
   }
}
// ServiceAvailableIF implementation --- end

// IEvolutionGeniviDbusPanProxyIf implementation --- start
act_t EvolutionGeniviDbusPanProxyIf::sendBtApplPanSendDataReqRequest(const ::std::vector< uint8 >& dest_addr, const ::std::vector< uint8 >& src_addr, uint16 pkt_type, const ::std::vector< uint8 >& data)
{
   if((NULL != _callbackIf) && (NULL != _panProxy.get()))
   {
      return _panProxy->sendBtApplPanSendDataReqRequest(*_callbackIf, dest_addr, src_addr, pkt_type, data);
   }
   else
   {
      return DEFAULT_ACT;
   }
}

act_t EvolutionGeniviDbusPanProxyIf::sendBtApplPanFilterNettypeReqRequest(uint16 nettype_num, const ::std::vector< uint8 >& nettype_filter_list)
{
   if((NULL != _callbackIf) && (NULL != _panProxy.get()))
   {
      return _panProxy->sendBtApplPanFilterNettypeReqRequest(*_callbackIf, nettype_num, nettype_filter_list);
   }
   else
   {
      return DEFAULT_ACT;
   }
}

act_t EvolutionGeniviDbusPanProxyIf::sendBtApplPanFilterMuladdrReqRequest(uint16 addr_num, const ::std::vector< uint8 >& addr_filter_list)
{
   if((NULL != _callbackIf) && (NULL != _panProxy.get()))
   {
      return _panProxy->sendBtApplPanFilterMuladdrReqRequest(*_callbackIf, addr_num, addr_filter_list);
   }
   else
   {
      return DEFAULT_ACT;
   }
}
// IEvolutionGeniviDbusPanProxyIf implementation --- end

} //ccdbusif
