/**
 * @file EvolutionGeniviDbusObexTransferProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for ObexTransfer.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for ObexTransfer.
 */

#include "EvolutionGeniviDbusObexTransferProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusObexTransferProperties::EvolutionGeniviDbusObexTransferProperties() : DbusProperties("Transfer"),
   // properties
   _propertyStatus("Status"),
   _propertySession("Session"),
   _propertyName("Name"),
   _propertyType("Type"),
   _propertyTime("Time"),
   _propertySize("Size"),
   _propertyTransferred("Transferred"),
   _propertyFilename("Filename")
{
   _string2EnumList[_propertyStatus] = (int)OBEX_TRANSFER_STATUS;
   _string2EnumList[_propertySession] = (int)OBEX_TRANSFER_SESSION;
   _string2EnumList[_propertyName] = (int)OBEX_TRANSFER_NAME;
   _string2EnumList[_propertyType] = (int)OBEX_TRANSFER_TYPE;
   _string2EnumList[_propertyTime] = (int)OBEX_TRANSFER_TIME;
   _string2EnumList[_propertySize] = (int)OBEX_TRANSFER_SIZE;
   _string2EnumList[_propertyTransferred] = (int)OBEX_TRANSFER_TRANSFERRED;
   _string2EnumList[_propertyFilename] = (int)OBEX_TRANSFER_FILENAME;

   _enum2StringList[(int)OBEX_TRANSFER_STATUS] = &_propertyStatus;
   _enum2StringList[(int)OBEX_TRANSFER_SESSION] = &_propertySession;
   _enum2StringList[(int)OBEX_TRANSFER_NAME] = &_propertyName;
   _enum2StringList[(int)OBEX_TRANSFER_TYPE] = &_propertyType;
   _enum2StringList[(int)OBEX_TRANSFER_TIME] = &_propertyTime;
   _enum2StringList[(int)OBEX_TRANSFER_SIZE] = &_propertySize;
   _enum2StringList[(int)OBEX_TRANSFER_TRANSFERRED] = &_propertyTransferred;
   _enum2StringList[(int)OBEX_TRANSFER_FILENAME] = &_propertyFilename;
}

EvolutionGeniviDbusObexTransferProperties::~EvolutionGeniviDbusObexTransferProperties()
{
}

ObexTransferProperty EvolutionGeniviDbusObexTransferProperties::getProperty2Enum(const ::std::string& value) const
{
   return (ObexTransferProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusObexTransferProperties::getProperty2String(const ObexTransferProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusObexTransferProperties::getProperty2StringTrace(const ObexTransferProperty value) const
{
   if(OBEX_TRANSFER_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
