/**
 * @file EvolutionGeniviDbusObexTransferFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for ObexTransfer.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for ObexTransfer.
 */

#include "EvolutionGeniviDbusObexTransferFactory.h"
#include "EvolutionGeniviDbusObexTransferProxyIf.h"

namespace ccdbusif {

EvolutionGeniviDbusObexTransferFactory::EvolutionGeniviDbusObexTransferFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusObexTransferFactory::~EvolutionGeniviDbusObexTransferFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusObexTransferFactory& EvolutionGeniviDbusObexTransferFactory::getInstance(void)
{
   static EvolutionGeniviDbusObexTransferFactory factory;
   return factory;
}

IEvolutionGeniviDbusObexTransferSendRequestIf* EvolutionGeniviDbusObexTransferFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(NULL != _proxy)
   {
      // already created
   }
   else
   {
      EvolutionGeniviDbusObexTransferProxyIf* tmp = new EvolutionGeniviDbusObexTransferProxyIf(client);
      _proxy = tmp;
      _destroyer = tmp;
      _createdLocally = true;
   }

   return _proxy;
}

void EvolutionGeniviDbusObexTransferFactory::destroyProxy(void)
{
   if((NULL != _proxy) && (true == _createdLocally))
   {
      delete _proxy;
      _proxy = NULL;
      _destroyer = NULL;
   }
}

void EvolutionGeniviDbusObexTransferFactory::setProxyForTesting(IEvolutionGeniviDbusObexTransferSendRequestIf* testProxy)
{
   if(NULL != _proxy)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _proxy = testProxy;
      _destroyer = NULL;
      _createdLocally = false;
   }
}

} //ccdbusif
