/**
 * @file EvolutionGeniviDbusObexSessionProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for ObexSession.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for ObexSession.
 */

#include "EvolutionGeniviDbusObexSessionProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusObexSessionProperties::EvolutionGeniviDbusObexSessionProperties() : DbusProperties("Session"),
   // properties
   _propertySource("Source"),
   _propertyDestination("Destination"),
   _propertyChannel("Channel"),
   _propertyTarget("Target"),
   _propertyInstanceId("InstanceID")
{
   _string2EnumList[_propertySource] = (int)OBEX_SESSION_SOURCE;
   _string2EnumList[_propertyDestination] = (int)OBEX_SESSION_DESTINATION;
   _string2EnumList[_propertyChannel] = (int)OBEX_SESSION_CHANNEL;
   _string2EnumList[_propertyTarget] = (int)OBEX_SESSION_TARGET;
   _string2EnumList[_propertyInstanceId] = (int)OBEX_SESSION_INSTANCEID;

   _enum2StringList[(int)OBEX_SESSION_SOURCE] = &_propertySource;
   _enum2StringList[(int)OBEX_SESSION_DESTINATION] = &_propertyDestination;
   _enum2StringList[(int)OBEX_SESSION_CHANNEL] = &_propertyChannel;
   _enum2StringList[(int)OBEX_SESSION_TARGET] = &_propertyTarget;
   _enum2StringList[(int)OBEX_SESSION_INSTANCEID] = &_propertyInstanceId;
}

EvolutionGeniviDbusObexSessionProperties::~EvolutionGeniviDbusObexSessionProperties()
{
}

ObexSessionProperty EvolutionGeniviDbusObexSessionProperties::getProperty2Enum(const ::std::string& value) const
{
   return (ObexSessionProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusObexSessionProperties::getProperty2String(const ObexSessionProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusObexSessionProperties::getProperty2StringTrace(const ObexSessionProperty value) const
{
   if(OBEX_SESSION_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
