/**
 * @file EvolutionGeniviDbusLEAdapterProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for LEAdapter.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for LEAdapter.
 */

#include "EvolutionGeniviDbusLEAdapterProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusLEAdapterProperties::EvolutionGeniviDbusLEAdapterProperties() : DbusProperties("LEAdapter1"),
   // properties
   _propertyAddressType("AddressType"),
   _propertyAddress("Address"),
   _propertyAlias("Alias"),
   _propertyAdvertisingTimeout("AdvertisingTimeout"),
   _propertyDiscoverableMode("DiscoverableMode"),
   _propertyAdvertisingData("AdvertisingData"),
   _propertyAdvertiseEnable("AdvertiseEnable")
{
   _string2EnumList[_propertyAddressType] = (int)LE_ADAPTER_ADDRESSTYPE;
   _string2EnumList[_propertyAddress] = (int)LE_ADAPTER_ADDRESS;
   _string2EnumList[_propertyAlias] = (int)LE_ADAPTER_ALIAS;
   _string2EnumList[_propertyAdvertisingTimeout] = (int)LE_ADAPTER_ADVERTISINGTIMEOUT;
   _string2EnumList[_propertyDiscoverableMode] = (int)LE_ADAPTER_DISCOVERABLEMODE;
   _string2EnumList[_propertyAdvertisingData] = (int)LE_ADAPTER_ADVERTISINGDATA;
   _string2EnumList[_propertyAdvertiseEnable] = (int)LE_ADAPTER_ADVERTISEENABLE;

   _enum2StringList[(int)LE_ADAPTER_ADDRESSTYPE] = &_propertyAddressType;
   _enum2StringList[(int)LE_ADAPTER_ADDRESS] = &_propertyAddress;
   _enum2StringList[(int)LE_ADAPTER_ALIAS] = &_propertyAlias;
   _enum2StringList[(int)LE_ADAPTER_ADVERTISINGTIMEOUT] = &_propertyAdvertisingTimeout;
   _enum2StringList[(int)LE_ADAPTER_DISCOVERABLEMODE] = &_propertyDiscoverableMode;
   _enum2StringList[(int)LE_ADAPTER_ADVERTISINGDATA] = &_propertyAdvertisingData;
   _enum2StringList[(int)LE_ADAPTER_ADVERTISEENABLE] = &_propertyAdvertiseEnable;
}

EvolutionGeniviDbusLEAdapterProperties::~EvolutionGeniviDbusLEAdapterProperties()
{
}

LEAdapterProperty EvolutionGeniviDbusLEAdapterProperties::getProperty2Enum(const ::std::string& value) const
{
   return (LEAdapterProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusLEAdapterProperties::getProperty2String(const LEAdapterProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusLEAdapterProperties::getProperty2StringTrace(const LEAdapterProperty value) const
{
   if(LE_ADAPTER_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
