/**
 * @file EvolutionGeniviDbusHfpNetworkRegistrationProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpNetworkRegistration.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpNetworkRegistration.
 */

#include "EvolutionGeniviDbusHfpNetworkRegistrationProxyIf.h"
#include "IEvolutionGeniviDbusHfpNetworkRegistrationCallbackIf.h"
#include "CcDbusIfTypes.h"
#include "CcDbusIfUtils.h"
#include "ICcDbusIfControllerClient.h"
#include "CcDbusIfCreateProxyWorkItem.h"
#include "CcDbusIfCreateRuntimeProxyWorkItem.h"
#include "CcDbusIfDestroyRuntimeProxyWorkItem.h"
#include "EvolutionGeniviDbusParser.h"

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

using namespace ::org::ofono::NetworkRegistration;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpNetworkRegistrationProxyIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::EvolutionGeniviDbusHfpNetworkRegistrationProxyIf()
{
   // _hfpNetworkRegistrationProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::EvolutionGeniviDbusHfpNetworkRegistrationProxyIf(ICcDbusIfControllerClient* client) : BaseDbusProxyIf(client)
{
   // _hfpNetworkRegistrationProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::~EvolutionGeniviDbusHfpNetworkRegistrationProxyIf()
{
   _callbackIf = NULL;
}

void EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::createProxy(void)
{
   // these proxies have to be created during runtime
}

void EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::destroyProxy(void)
{
   ETG_TRACE_USR3((" destroyProxy(): NetworkRegistration"));

   // these proxies have to be destroyed during runtime
   // destroy all proxies now if still available
   _hfpNetworkRegistrationProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::destroyAllRuntimeProxies(void)
{
   ETG_TRACE_USR3((" destroyAllRuntimeProxies(): NetworkRegistration"));

   for(unsigned int i = 0; i < _hfpNetworkRegistrationProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< NetworkRegistrationProxy >& hfpNetworkRegistrationProxy = _hfpNetworkRegistrationProxy[i];
      if(NULL != hfpNetworkRegistrationProxy.get())
      {
         hfpNetworkRegistrationProxy->sendDeregisterAll();
      }
   }

   _hfpNetworkRegistrationProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::createRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3((" createRuntimeProxy(): NetworkRegistration: objPath=%s", objPath.c_str()));

   if((NULL != _callbackIf) && (true == _enableProxy))
   {
      if(false == _hfpNetworkRegistrationProxy.isInstanceAvailable(objPath))
      {
         evolution::EvolutionGeniviDbusParser parser;
         ::boost::shared_ptr< NetworkRegistrationProxy > hfpNetworkRegistrationProxy = NetworkRegistrationProxy::createProxy("evoHfpNetworkRegistrationPort", parser.getInterface2BusName(evolution::IF_NETWORK_REGISTRATION), objPath, convertLocalBusType(parser.getInterface2BusType(evolution::IF_NETWORK_REGISTRATION)), *this);
         _hfpNetworkRegistrationProxy.addProxyInstance(objPath, hfpNetworkRegistrationProxy);
      }
   }
}

void EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::destroyRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3((" destroyRuntimeProxy(): NetworkRegistration: objPath=%s", objPath.c_str()));

   // HINT: destroying runtime proxy is not possible because ASF is storing a proxy "reference" internally; therefore reset() call will not causing destruction of proxy
   // HINT: due to this we explicitly have to call sendDeregisterAll() to force removing of signal registration (DBUS: member=RemoveMatch)
   // HINT: sendDeregisterAll() is automatically called during destruction of proxy

   ::boost::shared_ptr< NetworkRegistrationProxy > hfpNetworkRegistrationProxy;
   if(true == _hfpNetworkRegistrationProxy.isProxyAvailable(hfpNetworkRegistrationProxy, objPath))
   {
      hfpNetworkRegistrationProxy->sendDeregisterAll();
   }
   _hfpNetworkRegistrationProxy.removeProxyInstance(objPath);
}

void EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::setCallbackIf(IEvolutionGeniviDbusHfpNetworkRegistrationCallbackIf* callbackIf, bool enableProxy)
{
   _callbackIf = callbackIf;

   if(NULL != _callbackIf)
   {
      _enableProxy = enableProxy;
   }

   // callback interface is now available => but proxy will be created later
}

void EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::deviceCreated(const ::std::string& objPath)
{
   // create runtime proxy
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfCreateRuntimeProxyWorkItem(objPath, this));
   }
}

void EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::deviceRemoved(const ::std::string& objPath)
{
   // destroy runtime proxy
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfDestroyRuntimeProxyWorkItem(objPath, this));
   }
}

// ServiceAvailableIF implementation --- start
void EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onAvailable(): NetworkRegistration"));

   for(unsigned int i = 0; i < _hfpNetworkRegistrationProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< NetworkRegistrationProxy >& hfpNetworkRegistrationProxy = _hfpNetworkRegistrationProxy[i];
      if((NULL != hfpNetworkRegistrationProxy.get()) && (proxy == hfpNetworkRegistrationProxy))
      {
         if(NULL != _callbackIf)
         {
            hfpNetworkRegistrationProxy->sendPropertyChangedRegister(*_callbackIf);

            _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(), hfpNetworkRegistrationProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

void EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onUnavailable(): NetworkRegistration"));

   for(unsigned int i = 0; i < _hfpNetworkRegistrationProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< NetworkRegistrationProxy >& hfpNetworkRegistrationProxy = _hfpNetworkRegistrationProxy[i];
      if((NULL != hfpNetworkRegistrationProxy.get()) && (proxy == hfpNetworkRegistrationProxy))
      {
         hfpNetworkRegistrationProxy->sendDeregisterAll();

         if(NULL != _callbackIf)
         {
            _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(), hfpNetworkRegistrationProxy->getDBusObjectPath());
         }
         break;
      }
   }
}
// ServiceAvailableIF implementation --- end

// IEvolutionGeniviDbusHfpNetworkRegistrationProxyIf implementation --- start
act_t EvolutionGeniviDbusHfpNetworkRegistrationProxyIf::sendGetPropertiesRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< NetworkRegistrationProxy > proxy;
   if(true == _hfpNetworkRegistrationProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendGetPropertiesRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}
// IEvolutionGeniviDbusHfpNetworkRegistrationProxyIf implementation --- end

} //ccdbusif
