/**
 * @file EvolutionGeniviDbusHfpCallVolumeProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpCallVolume.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpCallVolume.
 */

#include "EvolutionGeniviDbusHfpCallVolumeProxyIf.h"
#include "IEvolutionGeniviDbusHfpCallVolumeCallbackIf.h"
#include "CcDbusIfTypes.h"
#include "CcDbusIfUtils.h"
#include "ICcDbusIfControllerClient.h"
#include "CcDbusIfCreateProxyWorkItem.h"
#include "CcDbusIfCreateRuntimeProxyWorkItem.h"
#include "CcDbusIfDestroyRuntimeProxyWorkItem.h"
#include "EvolutionGeniviDbusParser.h"

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

using namespace ::org::ofono::CallVolume;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpCallVolumeProxyIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

EvolutionGeniviDbusHfpCallVolumeProxyIf::EvolutionGeniviDbusHfpCallVolumeProxyIf()
{
   // _hfpCallVolumeProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusHfpCallVolumeProxyIf::EvolutionGeniviDbusHfpCallVolumeProxyIf(ICcDbusIfControllerClient* client) : BaseDbusProxyIf(client)
{
   // _hfpCallVolumeProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusHfpCallVolumeProxyIf::~EvolutionGeniviDbusHfpCallVolumeProxyIf()
{
   _callbackIf = NULL;
}

void EvolutionGeniviDbusHfpCallVolumeProxyIf::createProxy(void)
{
   // these proxies have to be created during runtime
}

void EvolutionGeniviDbusHfpCallVolumeProxyIf::destroyProxy(void)
{
   ETG_TRACE_USR3((" destroyProxy(): CallVolume"));

   // these proxies have to be destroyed during runtime
   // destroy all proxies now if still available
   _hfpCallVolumeProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpCallVolumeProxyIf::destroyAllRuntimeProxies(void)
{
   ETG_TRACE_USR3((" destroyAllRuntimeProxies(): CallVolume"));

   for(unsigned int i = 0; i < _hfpCallVolumeProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< CallVolumeProxy >& hfpCallVolumeProxy = _hfpCallVolumeProxy[i];
      if(NULL != hfpCallVolumeProxy.get())
      {
         hfpCallVolumeProxy->sendDeregisterAll();
      }
   }

   _hfpCallVolumeProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpCallVolumeProxyIf::createRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3((" createRuntimeProxy(): CallVolume: objPath=%s", objPath.c_str()));

   if((NULL != _callbackIf) && (true == _enableProxy))
   {
      if(false == _hfpCallVolumeProxy.isInstanceAvailable(objPath))
      {
         evolution::EvolutionGeniviDbusParser parser;
         ::boost::shared_ptr< CallVolumeProxy > hfpCallVolumeProxy = CallVolumeProxy::createProxy("evoHfpCallVolumePort", parser.getInterface2BusName(evolution::IF_CALL_VOLUME), objPath, convertLocalBusType(parser.getInterface2BusType(evolution::IF_CALL_VOLUME)), *this);
         _hfpCallVolumeProxy.addProxyInstance(objPath, hfpCallVolumeProxy);
      }
   }
}

void EvolutionGeniviDbusHfpCallVolumeProxyIf::destroyRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3((" destroyRuntimeProxy(): CallVolume: objPath=%s", objPath.c_str()));

   // HINT: destroying runtime proxy is not possible because ASF is storing a proxy "reference" internally; therefore reset() call will not causing destruction of proxy
   // HINT: due to this we explicitly have to call sendDeregisterAll() to force removing of signal registration (DBUS: member=RemoveMatch)
   // HINT: sendDeregisterAll() is automatically called during destruction of proxy

   ::boost::shared_ptr< CallVolumeProxy > hfpCallVolumeProxy;
   if(true == _hfpCallVolumeProxy.isProxyAvailable(hfpCallVolumeProxy, objPath))
   {
      hfpCallVolumeProxy->sendDeregisterAll();
   }
   _hfpCallVolumeProxy.removeProxyInstance(objPath);
}

void EvolutionGeniviDbusHfpCallVolumeProxyIf::setCallbackIf(IEvolutionGeniviDbusHfpCallVolumeCallbackIf* callbackIf, bool enableProxy)
{
   _callbackIf = callbackIf;

   if(NULL != _callbackIf)
   {
      _enableProxy = enableProxy;
   }

   // callback interface is now available => but proxy will be created later
}

void EvolutionGeniviDbusHfpCallVolumeProxyIf::deviceCreated(const ::std::string& objPath)
{
   // create runtime proxy
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfCreateRuntimeProxyWorkItem(objPath, this));
   }
}

void EvolutionGeniviDbusHfpCallVolumeProxyIf::deviceRemoved(const ::std::string& objPath)
{
   // destroy runtime proxy
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfDestroyRuntimeProxyWorkItem(objPath, this));
   }
}

// ServiceAvailableIF implementation --- start
void EvolutionGeniviDbusHfpCallVolumeProxyIf::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onAvailable(): CallVolume"));

   for(unsigned int i = 0; i < _hfpCallVolumeProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< CallVolumeProxy >& hfpCallVolumeProxy = _hfpCallVolumeProxy[i];
      if((NULL != hfpCallVolumeProxy.get()) && (proxy == hfpCallVolumeProxy))
      {
         if(NULL != _callbackIf)
         {
            hfpCallVolumeProxy->sendPropertyChangedRegister(*_callbackIf);

            _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(), hfpCallVolumeProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

void EvolutionGeniviDbusHfpCallVolumeProxyIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onUnavailable(): CallVolume"));

   for(unsigned int i = 0; i < _hfpCallVolumeProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< CallVolumeProxy >& hfpCallVolumeProxy = _hfpCallVolumeProxy[i];
      if((NULL != hfpCallVolumeProxy.get()) && (proxy == hfpCallVolumeProxy))
      {
         hfpCallVolumeProxy->sendDeregisterAll();

         if(NULL != _callbackIf)
         {
            _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(), hfpCallVolumeProxy->getDBusObjectPath());
         }
         break;
      }
   }
}
// ServiceAvailableIF implementation --- end

// IEvolutionGeniviDbusHfpCallVolumeProxyIf implementation --- start
act_t EvolutionGeniviDbusHfpCallVolumeProxyIf::sendGetPropertiesRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< CallVolumeProxy > proxy;
   if(true == _hfpCallVolumeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendGetPropertiesRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpCallVolumeProxyIf::sendSetPropertyRequest(const ::std::string& objPath, const ::std::string& property, const uint8 value)
{
   ::boost::shared_ptr< CallVolumeProxy > proxy;
   if(true == _hfpCallVolumeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         ::asf::dbus::DBusVariant variant;
         DbusVariant vValue;
         vValue.setUInt8(value);
         evolution::EvolutionGeniviDbusParser parser;
         parser.addVariantValue(variant, vValue);
         return proxy->sendSetPropertyRequest(*_callbackIf, property, variant);
      }
   }
   return DEFAULT_ACT;
}
// IEvolutionGeniviDbusHfpCallVolumeProxyIf implementation --- end

} //ccdbusif
