/**
 * @file EvolutionGeniviDbusHandleDeviceWorkItem.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Proxy: work item for handle device.
 */

#include "EvolutionGeniviDbusHandleDeviceWorkItem.h"
#include "IEvolutionGeniviDbusHandleDeviceIf.h"

#include <cstddef>

namespace ccdbusif {

EvolutionGeniviDbusHandleDeviceWorkItem::EvolutionGeniviDbusHandleDeviceWorkItem()
{
   _handleDeviceIf = NULL;
   _deviceCreated = false;
   // _objPath is is empty after instantiation
}

EvolutionGeniviDbusHandleDeviceWorkItem::EvolutionGeniviDbusHandleDeviceWorkItem(IEvolutionGeniviDbusHandleDeviceIf* handleDeviceIf, bool deviceCreated, const ::std::string& objPath)
{
   _handleDeviceIf = handleDeviceIf;
   _deviceCreated = deviceCreated;
   _objPath = objPath;
}

EvolutionGeniviDbusHandleDeviceWorkItem::~EvolutionGeniviDbusHandleDeviceWorkItem()
{
   _handleDeviceIf = NULL;
}

void EvolutionGeniviDbusHandleDeviceWorkItem::processWorkItem(void)
{
   if(NULL != _handleDeviceIf)
   {
      if(true == _deviceCreated)
      {
         _handleDeviceIf->handleDeviceCreated(_objPath);
      }
      else
      {
         _handleDeviceIf->handleDeviceRemoved(_objPath);
      }
   }
}

} //ccdbusif
