/**
 * @file EvolutionGeniviDbusGeniviTraceProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for GeniviTrace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for GeniviTrace.
 */

#include "EvolutionGeniviDbusGeniviTraceProxyIf.h"
#include "IEvolutionGeniviDbusGeniviTraceCallbackIf.h"
#include "CcDbusIfTypes.h"
#include "ICcDbusIfControllerClient.h"
#include "CcDbusIfCreateProxyWorkItem.h"

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

using namespace ::org::bluez::genivi::Trace;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusGeniviTraceProxyIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

EvolutionGeniviDbusGeniviTraceProxyIf::EvolutionGeniviDbusGeniviTraceProxyIf()
{
   // _geniviTraceProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusGeniviTraceProxyIf::EvolutionGeniviDbusGeniviTraceProxyIf(ICcDbusIfControllerClient* client) : BaseDbusProxyIf(client)
{
   // _geniviTraceProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusGeniviTraceProxyIf::~EvolutionGeniviDbusGeniviTraceProxyIf()
{
   _callbackIf = NULL;
}

void EvolutionGeniviDbusGeniviTraceProxyIf::createProxy(void)
{
   ETG_TRACE_USR3((" createProxy(): GeniviTrace"));

   if(NULL != _callbackIf)
   {
      if(true == _enableProxy)
      {
         _geniviTraceProxy = TraceProxy::createProxy("evoGeniviTracePort", *this);
      }
   }
}

void EvolutionGeniviDbusGeniviTraceProxyIf::destroyProxy(void)
{
   ETG_TRACE_USR3((" destroyProxy(): GeniviTrace"));

   if(NULL != _geniviTraceProxy.get())
   {
      _geniviTraceProxy->sendDeregisterAll();
      _geniviTraceProxy.reset();
   }
}

void EvolutionGeniviDbusGeniviTraceProxyIf::destroyAllRuntimeProxies(void)
{
   ETG_TRACE_USR3((" destroyAllRuntimeProxies(): GeniviTrace"));

   // nothing to do because this is a static proxy
}

void EvolutionGeniviDbusGeniviTraceProxyIf::setCallbackIf(IEvolutionGeniviDbusGeniviTraceCallbackIf* callbackIf, bool enableProxy)
{
   _callbackIf = callbackIf;

   if(NULL != _callbackIf)
   {
      _enableProxy = enableProxy;
   }

   // callback interface is now available => create proxy now
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfCreateProxyWorkItem(this));
   }
}

// ServiceAvailableIF implementation --- start
void EvolutionGeniviDbusGeniviTraceProxyIf::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onAvailable(): GeniviTrace"));

   if((NULL != _geniviTraceProxy.get()) && (proxy == _geniviTraceProxy))
   {
      if(NULL != _callbackIf)
      {
         _geniviTraceProxy->sendReportDebugTraceRegister(*_callbackIf);
         _geniviTraceProxy->sendFatalErrorRegister(*_callbackIf);

         _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _geniviTraceProxy->getDBusObjectPath());
      }
   }
}

void EvolutionGeniviDbusGeniviTraceProxyIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onUnavailable(): GeniviTrace"));

   if((NULL != _geniviTraceProxy.get()) && (proxy == _geniviTraceProxy))
   {
      _geniviTraceProxy->sendDeregisterAll();

      if(NULL != _callbackIf)
      {
         _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _geniviTraceProxy->getDBusObjectPath());
      }
   }
}
// ServiceAvailableIF implementation --- end

// IEvolutionGeniviDbusGeniviTraceProxyIf implementation --- start
// IEvolutionGeniviDbusGeniviTraceProxyIf implementation --- end

} //ccdbusif
