/**
 * @file EvolutionGeniviDbusDidProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for Did.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Did.
 */

#include "EvolutionGeniviDbusDidProxyIf.h"
#include "IEvolutionGeniviDbusDidCallbackIf.h"
#include "CcDbusIfTypes.h"
#include "ICcDbusIfControllerClient.h"
#include "CcDbusIfCreateProxyWorkItem.h"

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

using namespace ::org::alps::evo::DID;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusDidProxyIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

EvolutionGeniviDbusDidProxyIf::EvolutionGeniviDbusDidProxyIf()
{
   // _didProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusDidProxyIf::EvolutionGeniviDbusDidProxyIf(ICcDbusIfControllerClient* client) : BaseDbusProxyIf(client)
{
   // _didProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusDidProxyIf::~EvolutionGeniviDbusDidProxyIf()
{
   _callbackIf = NULL;
}

void EvolutionGeniviDbusDidProxyIf::createProxy(void)
{
   ETG_TRACE_USR3((" createProxy(): DID"));

   if(NULL != _callbackIf)
   {
      if(true == _enableProxy)
      {
         _didProxy = DIDProxy::createProxy("evoDidPort", *this);
      }
   }
}

void EvolutionGeniviDbusDidProxyIf::destroyProxy(void)
{
   ETG_TRACE_USR3((" destroyProxy(): DID"));

   if(NULL != _didProxy.get())
   {
      _didProxy->sendDeregisterAll();
      _didProxy.reset();
   }
}

void EvolutionGeniviDbusDidProxyIf::destroyAllRuntimeProxies(void)
{
   ETG_TRACE_USR3((" destroyAllRuntimeProxies(): DID"));

   // nothing to do because this is a static proxy
}

void EvolutionGeniviDbusDidProxyIf::setCallbackIf(IEvolutionGeniviDbusDidCallbackIf* callbackIf, bool enableProxy)
{
   _callbackIf = callbackIf;

   if(NULL != _callbackIf)
   {
      _enableProxy = enableProxy;
   }

   // callback interface is now available => create proxy now
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfCreateProxyWorkItem(this));
   }
}

// ServiceAvailableIF implementation --- start
void EvolutionGeniviDbusDidProxyIf::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onAvailable(): DID"));

   if((NULL != _didProxy.get()) && (proxy == _didProxy))
   {
      if(NULL != _callbackIf)
      {
         _didProxy->sendBtApplDidSetCfmRegister(*_callbackIf);

         _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _didProxy->getDBusObjectPath());
      }
   }
}

void EvolutionGeniviDbusDidProxyIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onUnavailable(): DID"));

   if((NULL != _didProxy.get()) && (proxy == _didProxy))
   {
      _didProxy->sendDeregisterAll();

      if(NULL != _callbackIf)
      {
         _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _didProxy->getDBusObjectPath());
      }
   }
}
// ServiceAvailableIF implementation --- end

// IEvolutionGeniviDbusDidProxyIf implementation --- start
act_t EvolutionGeniviDbusDidProxyIf::sendBtApplDidSetReqRequest(uint8 entry, const ::std::vector< uint8 >& record)
{
   if((NULL != _callbackIf) && (NULL != _didProxy.get()))
   {
      return _didProxy->sendBtApplDidSetReqRequest(*_callbackIf, entry, record);
   }
   else
   {
      return DEFAULT_ACT;
   }
}
// IEvolutionGeniviDbusDidProxyIf implementation --- end

} //ccdbusif
