/**
 * @file EvolutionGeniviDbusComponents.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for Components.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for Components.
 */

#include "EvolutionGeniviDbusComponents.h"
#include "FwAssert.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusComponents::EvolutionGeniviDbusComponents() : DbusProperties("Components"),
   _interfaceAdapter("org.bluez.Adapter1"),
   _interfaceAgentManager("org.bluez.AgentManager"),
   _interfaceDevice("org.bluez.Device1"),
   _interfaceService("org.bluez.Service"),
   _interfaceTrace("org.bluez.evo.Trace"),
   _interfaceGeniviTrace("org.bluez.genivi.Trace"),
   _interfaceDM("org.alps.evo.DM"),
   _interfaceSPP("org.alps.evo.SPP"),
   _interfaceDID("org.alps.evo.DID"),
   _interfaceDUN("org.alps.evo.DUN"),
   _interfacePAN("org.alps.evo.PAN"),
   _interfaceHandsfree("org.ofono.Handsfree"),
   _interfaceManager("org.ofono.Manager"),
   _interfaceModem("org.ofono.Modem"),
   _interfaceVoiceCall("org.ofono.VoiceCall"),
   _interfaceVoiceCallManager("org.ofono.VoiceCallManager"),
   _interfaceNetworkRegistration("org.ofono.NetworkRegistration"),
   _interfaceNetworkOperator("org.ofono.NetworkOperator"),
   _interfaceCallVolume("org.ofono.CallVolume"),
   _interfaceSiri("org.ofono.evo.Siri"),
   _interfaceAVP("org.bluez.evo.AVP"),
   _interfaceMediaFolder("org.bluez.MediaFolder"),
   _interfaceMediaItem("org.bluez.MediaItem"),
   _interfaceMediaPlayer("org.bluez.MediaPlayer"),
   _interfaceMediaTransport("org.bluez.MediaTransport"),
   _interfaceClient("org.bluez.obex.Client"),
   _interfacePhonebookAccess("org.bluez.obex.PhonebookAccess"),
   _interfaceSession("org.bluez.obex.Session"),
   _interfaceTransfer("org.bluez.obex.Transfer"),
   _interfaceMessage("org.bluez.obex.Message"),
   _interfaceMessageAccess("org.bluez.obex.MessageAccess"),
   _interfaceNetwork("org.bluez.Network1"),
   _interfaceSerial("org.bluez.Serial"),
   _interfaceLEAdapter("org.bluez.LE_Adapter1"),
   _interfaceLEDevice("org.bluez.LE_Device1"),
   _interfaceLESeamlessPairing("org.bluez.SeamlessPairing"),

   _busTypeSystem(BUS_TYPE_SYSTEM),
   _busTypeSession(BUS_TYPE_SESSION),

   _busName_org_bluez("org.bluez"),
   _busName_org_ofono("org.ofono"),
   _busName_org_bluez_obex("org.bluez.obex"),
   _busName_org_alps_evolution("org.alps.evolution"),

   // use empty string for dynamic object paths
   _objPathAdapter("/org/bluez/hci1"),
   _objPathAgentManager("/org/bluez"),
   _objPathDevice(""),
   _objPathService(""),
   _objPathTrace("/org/bluez/hci1"),
   _objPathGeniviTrace("/org/bluez/hci1"),
   _objPathDM("/org/alps/evolution/hli"),
   _objPathSPP("/org/alps/evolution/hli"),
   _objPathDID("/org/alps/evolution/hli"),
   _objPathDUN("/org/alps/evolution/hli"),
   _objPathPAN("/org/alps/evolution/hli"),
   _objPathHandsfree(""),
   _objPathManager("/"),
   _objPathModem(""),
   _objPathVoiceCall(""),
   _objPathVoiceCallManager(""),
   _objPathNetworkRegistration(""),
   _objPathNetworkOperator(""),
   _objPathCallVolume(""),
   _objPathSiri(""),
   _objPathAVP(""),
   _objPathMediaFolder(""),
   _objPathMediaItem(""),
   _objPathMediaPlayer(""),
   _objPathMediaTransport(""),
   _objPathClient("/org/bluez/obex"),
   _objPathPhonebookAccess(""),
   _objPathSession(""),
   _objPathTransfer(""),
   _objPathMessage(""),
   _objPathMessageAccess(""),
   _objPathNetwork(""),
   _objPathSerial(""),
   _objPathLEAdapter("/org/bluez/hci1"),
   _objPathLEDevice(""),
   _objPathLESeamlessPairing(""),

   _objPathRoot("/"),
   _busTypeAgent(BUS_TYPE_SYSTEM),
   _busNameAgent("org.agent"),
   _objPathAgent("/org/bosch/genivi"),

   _evoAdapterPort("evoAdapterPort"),
   _evoAgentManagerPort("evoAgentManagerPort"),
   _evoDevicePort("evoDevicePort"),
   _evoServicePort("evoServicePort"),
   _evoTracePort("evoTracePort"),
   _evoGeniviTracePort("evoGeniviTracePort"),
   _evoDMPort("evoDmPort"),
   _evoSPPPort("evoSppPort"),
   _evoDIDPort("evoDidPort"),
   _evoDUNPort("evoDunPort"),
   _evoPANPort("evoPanPort"),
   _evoHandsfreePort("evoHfpHandsfreePort"),
   _evoManagerPort("evoHfpManagerPort"),
   _evoModemPort("evoHfpModemPort"),
   _evoVoiceCallPort("evoHfpVoiceCallPort"),
   _evoVoiceCallManagerPort("evoHfpVoiceCallManagerPort"),
   _evoNetworkRegistrationPort("evoHfpNetworkRegistrationPort"),
   _evoNetworkOperatorPort("evoHfpNetworkOperatorPort"),
   _evoCallVolumePort("evoHfpCallVolumePort"),
   _evoSiriPort("evoHfpSiri"),
   _evoAVPPort("evoAvpAvpPort"),
   _evoMediaFolderPort("evoAvpMediaFolderPort"),
   _evoMediaItemPort("evoAvpMediaItemPort"),
   _evoMediaPlayerPort("evoAvpMediaPlayerPort"),
   _evoMediaTransportPort("evoAvpMediaTransportPort"),
   _evoClientPort("evoObexClientPort"),
   _evoPhonebookAccessPort("evoPhonebookAccessPort"),
   _evoSessionPort("evoObexSessionPort"),
   _evoTransferPort("evoObexTransferPort"),
   _evoMessagePort("evoMessagePort"),
   _evoMessageAccessPort("evoMessageAccessPort"),
   _evoNetworkPort("evoNetworkPort"),
   _evoSerialPort("evoSerialPort"),
   _evoLEAdapterPort("evoLEAdapterPort"),
   _evoLEDevicePort("evoLEDevicePort"),
   _evoLESeamlessPairingPort("evoLESeamlessPairingPort")
{
   _string2EnumList[_interfaceAdapter] = (int)IF_ADAPTER;
   _string2EnumList[_interfaceAgentManager] = (int)IF_AGENT_MANAGER;
   _string2EnumList[_interfaceDevice] = (int)IF_DEVICE;
   _string2EnumList[_interfaceService] = (int)IF_SERVICE;
   _string2EnumList[_interfaceTrace] = (int)IF_TRACE;
   _string2EnumList[_interfaceGeniviTrace] = (int)IF_GENIVI_TRACE;
   _string2EnumList[_interfaceDM] = (int)IF_DM;
   _string2EnumList[_interfaceSPP] = (int)IF_SPP;
   _string2EnumList[_interfaceDID] = (int)IF_DID;
   _string2EnumList[_interfaceDUN] = (int)IF_DUN;
   _string2EnumList[_interfacePAN] = (int)IF_PAN;
   _string2EnumList[_interfaceHandsfree] = (int)IF_HANDSFREE;
   _string2EnumList[_interfaceManager] = (int)IF_MANAGER;
   _string2EnumList[_interfaceModem] = (int)IF_MODEM;
   _string2EnumList[_interfaceVoiceCall] = (int)IF_VOICE_CALL;
   _string2EnumList[_interfaceVoiceCallManager] = (int)IF_VOICE_CALL_MANAGER;
   _string2EnumList[_interfaceNetworkRegistration] = (int)IF_NETWORK_REGISTRATION;
   _string2EnumList[_interfaceNetworkOperator] = (int)IF_NETWORK_OPERATOR;
   _string2EnumList[_interfaceCallVolume] = (int)IF_CALL_VOLUME;
   _string2EnumList[_interfaceSiri] = (int)IF_SIRI;
   _string2EnumList[_interfaceAVP] = (int)IF_AVP;
   _string2EnumList[_interfaceMediaFolder] = (int)IF_MEDIA_FOLDER;
   _string2EnumList[_interfaceMediaItem] = (int)IF_MEDIA_ITEM;
   _string2EnumList[_interfaceMediaPlayer] = (int)IF_MEDIA_PLAYER;
   _string2EnumList[_interfaceMediaTransport] = (int)IF_MEDIA_TRANSPORT;
   _string2EnumList[_interfaceClient] = (int)IF_CLIENT;
   _string2EnumList[_interfacePhonebookAccess] = (int)IF_PHONEBOOK_ACCESS;
   _string2EnumList[_interfaceSession] = (int)IF_SESSION;
   _string2EnumList[_interfaceTransfer] = (int)IF_TRANSFER;
   _string2EnumList[_interfaceMessage] = (int)IF_MESSAGE;
   _string2EnumList[_interfaceMessageAccess] = (int)IF_MESSAGE_ACCESS;
   _string2EnumList[_interfaceNetwork] = (int)IF_NETWORK;
   _string2EnumList[_interfaceSerial] = (int)IF_SERIAL;
   _string2EnumList[_interfaceLEAdapter] = (int)IF_LE_ADAPTER;
   _string2EnumList[_interfaceLEDevice] = (int)IF_LE_DEVICE;
   _string2EnumList[_interfaceLESeamlessPairing] = (int)IF_LE_SEAMLESS_PAIRING;

   _enum2StringList[(int)IF_ADAPTER] = &_interfaceAdapter;
   _enum2StringList[(int)IF_AGENT_MANAGER] = &_interfaceAgentManager;
   _enum2StringList[(int)IF_DEVICE] = &_interfaceDevice;
   _enum2StringList[(int)IF_SERVICE] = &_interfaceService;
   _enum2StringList[(int)IF_TRACE] = &_interfaceTrace;
   _enum2StringList[(int)IF_GENIVI_TRACE] = &_interfaceGeniviTrace;
   _enum2StringList[(int)IF_DM] = &_interfaceDM;
   _enum2StringList[(int)IF_SPP] = &_interfaceSPP;
   _enum2StringList[(int)IF_DID] = &_interfaceDID;
   _enum2StringList[(int)IF_DUN] = &_interfaceDUN;
   _enum2StringList[(int)IF_PAN] = &_interfacePAN;
   _enum2StringList[(int)IF_HANDSFREE] = &_interfaceHandsfree;
   _enum2StringList[(int)IF_MANAGER] = &_interfaceManager;
   _enum2StringList[(int)IF_MODEM] = &_interfaceModem;
   _enum2StringList[(int)IF_VOICE_CALL] = &_interfaceVoiceCall;
   _enum2StringList[(int)IF_VOICE_CALL_MANAGER] = &_interfaceVoiceCallManager;
   _enum2StringList[(int)IF_NETWORK_REGISTRATION] = &_interfaceNetworkRegistration;
   _enum2StringList[(int)IF_NETWORK_OPERATOR] = &_interfaceNetworkOperator;
   _enum2StringList[(int)IF_CALL_VOLUME] = &_interfaceCallVolume;
   _enum2StringList[(int)IF_SIRI] = &_interfaceSiri;
   _enum2StringList[(int)IF_AVP] = &_interfaceAVP;
   _enum2StringList[(int)IF_MEDIA_FOLDER] = &_interfaceMediaFolder;
   _enum2StringList[(int)IF_MEDIA_ITEM] = &_interfaceMediaItem;
   _enum2StringList[(int)IF_MEDIA_PLAYER] = &_interfaceMediaPlayer;
   _enum2StringList[(int)IF_MEDIA_TRANSPORT] = &_interfaceMediaTransport;
   _enum2StringList[(int)IF_CLIENT] = &_interfaceClient;
   _enum2StringList[(int)IF_PHONEBOOK_ACCESS] = &_interfacePhonebookAccess;
   _enum2StringList[(int)IF_SESSION] = &_interfaceSession;
   _enum2StringList[(int)IF_TRANSFER] = &_interfaceTransfer;
   _enum2StringList[(int)IF_MESSAGE] = &_interfaceMessage;
   _enum2StringList[(int)IF_MESSAGE_ACCESS] = &_interfaceMessageAccess;
   _enum2StringList[(int)IF_NETWORK] = &_interfaceNetwork;
   _enum2StringList[(int)IF_SERIAL] = &_interfaceSerial;
   _enum2StringList[(int)IF_LE_ADAPTER] = &_interfaceLEAdapter;
   _enum2StringList[(int)IF_LE_DEVICE] = &_interfaceLEDevice;
   _enum2StringList[(int)IF_LE_SEAMLESS_PAIRING] = &_interfaceLESeamlessPairing;

   _interface2BusType[IF_ADAPTER] = _busTypeSystem;
   _interface2BusType[IF_AGENT_MANAGER] = _busTypeSystem;
   _interface2BusType[IF_DEVICE] = _busTypeSystem;
   _interface2BusType[IF_SERVICE] = _busTypeSystem;
   _interface2BusType[IF_TRACE] = _busTypeSystem;
   _interface2BusType[IF_GENIVI_TRACE] = _busTypeSystem;
   _interface2BusType[IF_DM] = _busTypeSystem;
   _interface2BusType[IF_SPP] = _busTypeSystem;
   _interface2BusType[IF_DID] = _busTypeSystem;
   _interface2BusType[IF_DUN] = _busTypeSystem;
   _interface2BusType[IF_PAN] = _busTypeSystem;
   _interface2BusType[IF_HANDSFREE] = _busTypeSystem;
   _interface2BusType[IF_MANAGER] = _busTypeSystem;
   _interface2BusType[IF_MODEM] = _busTypeSystem;
   _interface2BusType[IF_VOICE_CALL] = _busTypeSystem;
   _interface2BusType[IF_VOICE_CALL_MANAGER] = _busTypeSystem;
   _interface2BusType[IF_NETWORK_REGISTRATION] = _busTypeSystem;
   _interface2BusType[IF_NETWORK_OPERATOR] = _busTypeSystem;
   _interface2BusType[IF_CALL_VOLUME] = _busTypeSystem;
   _interface2BusType[IF_SIRI] = _busTypeSystem;
   _interface2BusType[IF_AVP] = _busTypeSystem;
   _interface2BusType[IF_MEDIA_FOLDER] = _busTypeSystem;
   _interface2BusType[IF_MEDIA_ITEM] = _busTypeSystem;
   _interface2BusType[IF_MEDIA_PLAYER] = _busTypeSystem;
   _interface2BusType[IF_MEDIA_TRANSPORT] = _busTypeSystem;
   _interface2BusType[IF_CLIENT] = _busTypeSession;
   _interface2BusType[IF_PHONEBOOK_ACCESS] = _busTypeSession;
   _interface2BusType[IF_SESSION] = _busTypeSession;
   _interface2BusType[IF_TRANSFER] = _busTypeSession;
   _interface2BusType[IF_MESSAGE] = _busTypeSession;
   _interface2BusType[IF_MESSAGE_ACCESS] = _busTypeSession;
   _interface2BusType[IF_NETWORK] = _busTypeSystem;
   _interface2BusType[IF_SERIAL] = _busTypeSystem;
   _interface2BusType[IF_LE_ADAPTER] = _busTypeSystem;
   _interface2BusType[IF_LE_DEVICE] = _busTypeSystem;
   _interface2BusType[IF_LE_SEAMLESS_PAIRING] = _busTypeSystem;

   _interface2BusName[IF_ADAPTER] = &_busName_org_bluez;
   _interface2BusName[IF_AGENT_MANAGER] = &_busName_org_bluez;
   _interface2BusName[IF_DEVICE] = &_busName_org_bluez;
   _interface2BusName[IF_SERVICE] = &_busName_org_bluez;
   _interface2BusName[IF_TRACE] = &_busName_org_bluez;
   _interface2BusName[IF_GENIVI_TRACE] = &_busName_org_bluez;
   _interface2BusName[IF_DM] = &_busName_org_alps_evolution;
   _interface2BusName[IF_SPP] = &_busName_org_alps_evolution;
   _interface2BusName[IF_DID] = &_busName_org_alps_evolution;
   _interface2BusName[IF_DUN] = &_busName_org_alps_evolution;
   _interface2BusName[IF_PAN] = &_busName_org_alps_evolution;
   _interface2BusName[IF_HANDSFREE] = &_busName_org_ofono;
   _interface2BusName[IF_MANAGER] = &_busName_org_ofono;
   _interface2BusName[IF_MODEM] = &_busName_org_ofono;
   _interface2BusName[IF_VOICE_CALL] = &_busName_org_ofono;
   _interface2BusName[IF_VOICE_CALL_MANAGER] = &_busName_org_ofono;
   _interface2BusName[IF_NETWORK_REGISTRATION] = &_busName_org_ofono;
   _interface2BusName[IF_NETWORK_OPERATOR] = &_busName_org_ofono;
   _interface2BusName[IF_CALL_VOLUME] = &_busName_org_ofono;
   _interface2BusName[IF_SIRI] = &_busName_org_ofono;
   _interface2BusName[IF_AVP] = &_busName_org_bluez;
   _interface2BusName[IF_MEDIA_FOLDER] = &_busName_org_bluez;
   _interface2BusName[IF_MEDIA_ITEM] = &_busName_org_bluez;
   _interface2BusName[IF_MEDIA_PLAYER] = &_busName_org_bluez;
   _interface2BusName[IF_MEDIA_TRANSPORT] = &_busName_org_bluez;
   _interface2BusName[IF_CLIENT] = &_busName_org_bluez_obex;
   _interface2BusName[IF_PHONEBOOK_ACCESS] = &_busName_org_bluez_obex;
   _interface2BusName[IF_SESSION] = &_busName_org_bluez_obex;
   _interface2BusName[IF_TRANSFER] = &_busName_org_bluez_obex;
   _interface2BusName[IF_MESSAGE] = &_busName_org_bluez_obex;
   _interface2BusName[IF_MESSAGE_ACCESS] = &_busName_org_bluez_obex;
   _interface2BusName[IF_NETWORK] = &_busName_org_bluez;
   _interface2BusName[IF_SERIAL] = &_busName_org_bluez;
   _interface2BusName[IF_LE_ADAPTER] = &_busName_org_bluez;
   _interface2BusName[IF_LE_DEVICE] = &_busName_org_bluez;
   _interface2BusName[IF_LE_SEAMLESS_PAIRING] = &_busName_org_bluez;

   _interface2ObjectPath[IF_ADAPTER] = &_objPathAdapter;
   _interface2ObjectPath[IF_AGENT_MANAGER] = &_objPathAgentManager;
   _interface2ObjectPath[IF_DEVICE] = &_objPathDevice;
   _interface2ObjectPath[IF_SERVICE] = &_objPathService;
   _interface2ObjectPath[IF_TRACE] = &_objPathTrace;
   _interface2ObjectPath[IF_GENIVI_TRACE] = &_objPathGeniviTrace;
   _interface2ObjectPath[IF_DM] = &_objPathDM;
   _interface2ObjectPath[IF_SPP] = &_objPathSPP;
   _interface2ObjectPath[IF_DID] = &_objPathDID;
   _interface2ObjectPath[IF_DUN] = &_objPathDUN;
   _interface2ObjectPath[IF_PAN] = &_objPathPAN;
   _interface2ObjectPath[IF_HANDSFREE] = &_objPathHandsfree;
   _interface2ObjectPath[IF_MANAGER] = &_objPathManager;
   _interface2ObjectPath[IF_MODEM] = &_objPathModem;
   _interface2ObjectPath[IF_VOICE_CALL] = &_objPathVoiceCall;
   _interface2ObjectPath[IF_VOICE_CALL_MANAGER] = &_objPathVoiceCallManager;
   _interface2ObjectPath[IF_NETWORK_REGISTRATION] = &_objPathNetworkRegistration;
   _interface2ObjectPath[IF_NETWORK_OPERATOR] = &_objPathNetworkOperator;
   _interface2ObjectPath[IF_CALL_VOLUME] = &_objPathCallVolume;
   _interface2ObjectPath[IF_SIRI] = &_objPathSiri;
   _interface2ObjectPath[IF_AVP] = &_objPathAVP;
   _interface2ObjectPath[IF_MEDIA_FOLDER] = &_objPathMediaFolder;
   _interface2ObjectPath[IF_MEDIA_ITEM] = &_objPathMediaItem;
   _interface2ObjectPath[IF_MEDIA_PLAYER] = &_objPathMediaPlayer;
   _interface2ObjectPath[IF_MEDIA_TRANSPORT] = &_objPathMediaTransport;
   _interface2ObjectPath[IF_CLIENT] = &_objPathClient;
   _interface2ObjectPath[IF_PHONEBOOK_ACCESS] = &_objPathPhonebookAccess;
   _interface2ObjectPath[IF_SESSION] = &_objPathSession;
   _interface2ObjectPath[IF_TRANSFER] = &_objPathTransfer;
   _interface2ObjectPath[IF_MESSAGE] = &_objPathMessage;
   _interface2ObjectPath[IF_MESSAGE_ACCESS] = &_objPathMessageAccess;
   _interface2ObjectPath[IF_NETWORK] = &_objPathNetwork;
   _interface2ObjectPath[IF_SERIAL] = &_objPathSerial;
   _interface2ObjectPath[IF_LE_ADAPTER] = &_objPathLEAdapter;
   _interface2ObjectPath[IF_LE_DEVICE] = &_objPathLEDevice;
   _interface2ObjectPath[IF_LE_SEAMLESS_PAIRING] = &_objPathLESeamlessPairing;

   _interface2Port[IF_ADAPTER] = &_evoAdapterPort;
   _interface2Port[IF_AGENT_MANAGER] = &_evoAgentManagerPort;
   _interface2Port[IF_DEVICE] = &_evoDevicePort;
   _interface2Port[IF_SERVICE] = &_evoServicePort;
   _interface2Port[IF_TRACE] = &_evoTracePort;
   _interface2Port[IF_GENIVI_TRACE] = &_evoGeniviTracePort;
   _interface2Port[IF_DM] = &_evoDMPort;
   _interface2Port[IF_SPP] = &_evoSPPPort;
   _interface2Port[IF_DID] = &_evoDIDPort;
   _interface2Port[IF_DUN] = &_evoDUNPort;
   _interface2Port[IF_PAN] = &_evoPANPort;
   _interface2Port[IF_HANDSFREE] = &_evoHandsfreePort;
   _interface2Port[IF_MANAGER] = &_evoManagerPort;
   _interface2Port[IF_MODEM] = &_evoModemPort;
   _interface2Port[IF_VOICE_CALL] = &_evoVoiceCallPort;
   _interface2Port[IF_VOICE_CALL_MANAGER] = &_evoVoiceCallManagerPort;
   _interface2Port[IF_NETWORK_REGISTRATION] = &_evoNetworkRegistrationPort;
   _interface2Port[IF_NETWORK_OPERATOR] = &_evoNetworkOperatorPort;
   _interface2Port[IF_CALL_VOLUME] = &_evoCallVolumePort;
   _interface2Port[IF_SIRI] = &_evoSiriPort;
   _interface2Port[IF_AVP] = &_evoAVPPort;
   _interface2Port[IF_MEDIA_FOLDER] = &_evoMediaFolderPort;
   _interface2Port[IF_MEDIA_ITEM] = &_evoMediaItemPort;
   _interface2Port[IF_MEDIA_PLAYER] = &_evoMediaPlayerPort;
   _interface2Port[IF_MEDIA_TRANSPORT] = &_evoMediaTransportPort;
   _interface2Port[IF_CLIENT] = &_evoClientPort;
   _interface2Port[IF_PHONEBOOK_ACCESS] = &_evoPhonebookAccessPort;
   _interface2Port[IF_SESSION] = &_evoSessionPort;
   _interface2Port[IF_TRANSFER] = &_evoTransferPort;
   _interface2Port[IF_MESSAGE] = &_evoMessagePort;
   _interface2Port[IF_MESSAGE_ACCESS] = &_evoMessageAccessPort;
   _interface2Port[IF_NETWORK] = &_evoNetworkPort;
   _interface2Port[IF_SERIAL] = &_evoSerialPort;
   _interface2Port[IF_LE_ADAPTER] = &_evoLEAdapterPort;
   _interface2Port[IF_LE_DEVICE] = &_evoLEDevicePort;
   _interface2Port[IF_LE_SEAMLESS_PAIRING] = &_evoLESeamlessPairingPort;
}

EvolutionGeniviDbusComponents::~EvolutionGeniviDbusComponents()
{
}

Interface EvolutionGeniviDbusComponents::getInterface2Enum(const ::std::string& value) const
{
   return (Interface)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusComponents::getInterface2String(const Interface value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusComponents::getInterface2StringTrace(const Interface value) const
{
   if(IF_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

DbusBusType EvolutionGeniviDbusComponents::getInterface2BusType(const Interface value) const
{
   if(IF_UNKNOWN <= value)
   {
      FW_NORMAL_ASSERT_ALWAYS();
      return _busTypeSystem;
   }

   return _interface2BusType[value];
}

const ::std::string& EvolutionGeniviDbusComponents::getInterface2BusName(const Interface value) const
{
   if(IF_UNKNOWN <= value)
   {
      FW_NORMAL_ASSERT_ALWAYS();
      return _emptyString;
   }

   if(0 == _interface2BusName[value])
   {
      FW_NORMAL_ASSERT_ALWAYS();
      return _emptyString;
   }

   return *_interface2BusName[value];
}

const ::std::string& EvolutionGeniviDbusComponents::getInterface2ObjectPath(const Interface value) const
{
   if(IF_UNKNOWN <= value)
   {
      FW_NORMAL_ASSERT_ALWAYS();
      return _emptyString;
   }

   if(0 == _interface2ObjectPath[value])
   {
      FW_NORMAL_ASSERT_ALWAYS();
      return _emptyString;
   }

   return *_interface2ObjectPath[value];
}

const ::std::string& EvolutionGeniviDbusComponents::getInterface2Port(const Interface value) const
{
   if(IF_UNKNOWN <= value)
   {
      FW_NORMAL_ASSERT_ALWAYS();
      return _emptyString;
   }

   if(0 == _interface2Port[value])
   {
      FW_NORMAL_ASSERT_ALWAYS();
      return _emptyString;
   }

   return *_interface2Port[value];
}

} //evolution
} //ccdbusif
