/**
 * @file EvolutionGeniviDbusAgentStubIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS stub for Agent.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS stub for Agent.
 */

#include "EvolutionGeniviDbusAgentStubIf.h"
#include "EvolutionGeniviDbusAgentServer.h"
#include "IEvolutionGeniviDbusAgentTestStubIf.h"
#include "ICcDbusIfControllerClient.h"
#include "SetCallbackWorkItem.h"
#include "TraceClasses.h"
#include "FwAssert.h"
#include "FwTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusAgentStubIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusAgentStubIf::EvolutionGeniviDbusAgentStubIf(ICcDbusIfControllerClient* client) :
CommonBaseProxyIf(client),
_callbackIf(0),
_agentStub(0),
_testStubIf(0),
_stubCreated(false)
{
}

EvolutionGeniviDbusAgentStubIf::EvolutionGeniviDbusAgentStubIf(ICcDbusIfControllerClient* client, IEvolutionGeniviDbusAgentTestStubIf* testStubIf) :
CommonBaseProxyIf(client),
_callbackIf(0),
_agentStub(0),
_testStubIf(testStubIf),
_stubCreated(false)
{
}

EvolutionGeniviDbusAgentStubIf::EvolutionGeniviDbusAgentStubIf(const EvolutionGeniviDbusAgentStubIf& ref) :
CommonBaseProxyIf(ref),
_callbackIf(ref._callbackIf),
_agentStub(0 /*ref._agentStub*/),
_testStubIf(ref._testStubIf),
_stubCreated(ref._stubCreated)
{
   // DO NOT USE!!!
   FW_NORMAL_ASSERT_ALWAYS();
}

EvolutionGeniviDbusAgentStubIf& EvolutionGeniviDbusAgentStubIf::operator=(const EvolutionGeniviDbusAgentStubIf& ref)
{
   // DO NOT USE!!!
   FW_NORMAL_ASSERT_ALWAYS();

   if(this == &ref)
   {
      return *this;
   }

   CommonBaseProxyIf::operator=(ref);

   _callbackIf = ref._callbackIf;
   _agentStub = 0 /*ref._agentStub*/;
   _testStubIf = ref._testStubIf;
   _stubCreated = ref._stubCreated;

   return *this;
}

EvolutionGeniviDbusAgentStubIf::~EvolutionGeniviDbusAgentStubIf()
{
   _callbackIf = 0;
   if(0 != _agentStub)
   {
      delete _agentStub;
   }
   _testStubIf = 0;
}

void EvolutionGeniviDbusAgentStubIf::handleSetCallback(IEvolutionGeniviDbusAgentCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   (void)(callbackId);
   (void)(objPath);
   (void)(busName);
   (void)(busType);

   _enableProxy = enableProxy;
   _callbackIf = callbackIf;
}

void EvolutionGeniviDbusAgentStubIf::handleCreateProxy(const unsigned int callbackId, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   internalCreateProxy(callbackId, objPath, busName, busType);
}

void EvolutionGeniviDbusAgentStubIf::handleDestroyProxy(const unsigned int callbackId, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   internalDestroyProxy(callbackId, objPath, busName, busType);
}

void EvolutionGeniviDbusAgentStubIf::handleDestroyAllProxies(void)
{
   internalDestroyAllProxies();
}

void EvolutionGeniviDbusAgentStubIf::handleDestroyAllRuntimeProxies(void)
{
   internalDestroyAllRuntimeProxies();
}

IDestroyAllProxies* EvolutionGeniviDbusAgentStubIf::getDestroyer(void)
{
   return this;
}

void EvolutionGeniviDbusAgentStubIf::setCallbackIf(IEvolutionGeniviDbusAgentCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   processSetCallback(callbackIf, enableProxy, callbackId, objPath, busName, busType);
}

void EvolutionGeniviDbusAgentStubIf::createStubIf(const unsigned int callbackId, const bool createDirectly /*= false*/, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   processCreateProxy(this, createDirectly, callbackId, objPath, busName, busType);
}

void EvolutionGeniviDbusAgentStubIf::destroyStubIf(const unsigned int callbackId, const bool createDirectly /*= false*/, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   processDestroyProxy(this, createDirectly, callbackId, objPath, busName, busType);
}

void EvolutionGeniviDbusAgentStubIf::sendReleaseResponse(const unsigned int callbackId, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendReleaseResponse(act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendReleaseResponse(act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendReleaseError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendReleaseError(errorName, errorMessage, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendReleaseError(errorName, errorMessage, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendRequestPinCodeResponse(const unsigned int callbackId, const ::std::string& pincode, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendRequestPinCodeResponse(pincode, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendRequestPinCodeResponse(pincode, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendRequestPinCodeError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendRequestPinCodeError(errorName, errorMessage, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendRequestPinCodeError(errorName, errorMessage, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendDisplayPinCodeResponse(const unsigned int callbackId, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendDisplayPinCodeResponse(act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendDisplayPinCodeResponse(act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendDisplayPinCodeError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendDisplayPinCodeError(errorName, errorMessage, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendDisplayPinCodeError(errorName, errorMessage, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendRequestPasskeyResponse(const unsigned int callbackId, uint32 passkey, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendRequestPasskeyResponse(passkey, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendRequestPasskeyResponse(passkey, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendRequestPasskeyError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendRequestPasskeyError(errorName, errorMessage, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendRequestPasskeyError(errorName, errorMessage, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendRequestConfirmationResponse(const unsigned int callbackId, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendRequestConfirmationResponse(act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendRequestConfirmationResponse(act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendRequestConfirmationError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendRequestConfirmationError(errorName, errorMessage, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendRequestConfirmationError(errorName, errorMessage, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendCancelResponse(const unsigned int callbackId, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendCancelResponse(act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendCancelResponse(act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendCancelRequestResponse(const unsigned int callbackId, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendCancelRequestResponse(act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendCancelRequestResponse(act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendAuthorizeServiceResponse(const unsigned int callbackId, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendAuthorizeServiceResponse(act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendAuthorizeServiceResponse(act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendAuthorizeServiceError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendAuthorizeServiceError(errorName, errorMessage, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendAuthorizeServiceError(errorName, errorMessage, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendRequestAuthorizationResponse(const unsigned int callbackId, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendRequestAuthorizationResponse(act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendRequestAuthorizationResponse(act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendRequestAuthorizationError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendRequestAuthorizationError(errorName, errorMessage, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendRequestAuthorizationError(errorName, errorMessage, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendRequestLinkkeyResponse(const unsigned int callbackId, const ::std::vector< uint8 >& linkkey, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendRequestLinkkeyResponse(linkkey, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendRequestLinkkeyResponse(linkkey, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendRequestLinkkeyError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendRequestLinkkeyError(errorName, errorMessage, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendRequestLinkkeyError(errorName, errorMessage, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendDisplayPasskeyResponse(const unsigned int callbackId, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendDisplayPasskeyResponse(act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendDisplayPasskeyResponse(act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::sendDisplayPasskeyError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act)
{
   (void)(callbackId);

   if(0 != _testStubIf)
   {
      _testStubIf->sendDisplayPasskeyError(errorName, errorMessage, act);
   }
   else
   {
      if(0 != _agentStub)
      {
         _agentStub->sendDisplayPasskeyError(errorName, errorMessage, act);
      }
   }
}

void EvolutionGeniviDbusAgentStubIf::onReleaseRequest(const ::boost::shared_ptr< ReleaseRequest >& request, const act_t act)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onReleaseRequest(request, act);
   }
}

void EvolutionGeniviDbusAgentStubIf::onRequestPinCodeRequest(const ::boost::shared_ptr< RequestPinCodeRequest >& request, const act_t act)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onRequestPinCodeRequest(request, act);
   }
}

void EvolutionGeniviDbusAgentStubIf::onDisplayPinCodeRequest(const ::boost::shared_ptr< DisplayPinCodeRequest >& request, const act_t act)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onDisplayPinCodeRequest(request, act);
   }
}

void EvolutionGeniviDbusAgentStubIf::onRequestPasskeyRequest(const ::boost::shared_ptr< RequestPasskeyRequest >& request, const act_t act)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onRequestPasskeyRequest(request, act);
   }
}

void EvolutionGeniviDbusAgentStubIf::onRequestConfirmationRequest(const ::boost::shared_ptr< RequestConfirmationRequest >& request, const act_t act)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onRequestConfirmationRequest(request, act);
   }
}

void EvolutionGeniviDbusAgentStubIf::onCancelRequest(const ::boost::shared_ptr< CancelRequest >& request, const act_t act)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onCancelRequest(request, act);
   }
}

void EvolutionGeniviDbusAgentStubIf::onCancelRequestRequest(const ::boost::shared_ptr< CancelRequestRequest >& request, const act_t act)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onCancelRequestRequest(request, act);
   }
}

void EvolutionGeniviDbusAgentStubIf::onAuthorizeServiceRequest(const ::boost::shared_ptr< AuthorizeServiceRequest >& request, const act_t act)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onAuthorizeServiceRequest(request, act);
   }
}

void EvolutionGeniviDbusAgentStubIf::onRequestAuthorizationRequest(const ::boost::shared_ptr< RequestAuthorizationRequest >& request, const act_t act)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onRequestAuthorizationRequest(request, act);
   }
}

void EvolutionGeniviDbusAgentStubIf::onRequestLinkkeyRequest(const ::boost::shared_ptr< RequestLinkkeyRequest >& request, const act_t act)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onRequestLinkkeyRequest(request, act);
   }
}

void EvolutionGeniviDbusAgentStubIf::onDisplayPasskeyRequest (const ::boost::shared_ptr< DisplayPasskeyRequest >& request, const act_t act)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onDisplayPasskeyRequest(request, act);
   }
}

void EvolutionGeniviDbusAgentStubIf::internalCreateProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType)
{
   // check if stub is available
   if(false == isStubAvailable())
   {
      ETG_TRACE_USR3((" internalCreateProxy(): Agent: callbackId=%u busType=%d busName=%20s objPath=%s (create)", callbackId, busType, busName.c_str(), objPath.c_str()));

      // create stub
      if(0 != _testStubIf)
      {
         _testStubIf->createStub(*this, "evoAgentPort", objPath, busName, busType);
         addStub();
      }
      else
      {
         if(0 == _agentStub)
         {
            _agentStub = new EvolutionGeniviDbusAgentServer(_callbackIf);
         }
         addStub();
      }
   }
   else
   {
      ETG_TRACE_USR3((" internalCreateProxy(): Agent: callbackId=%u busType=%d busName=%20s objPath=%s (already done)", callbackId, busType, busName.c_str(), objPath.c_str()));
   }
}

void EvolutionGeniviDbusAgentStubIf::internalDestroyProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType)
{
   // check if stub is available
   if(true == isStubAvailable())
   {
      ETG_TRACE_USR3((" internalDestroyProxy(): Agent: callbackId=%u busType=%d busName=%20s objPath=%s (destroy)", callbackId, busType, busName.c_str(), objPath.c_str()));

      // destroy stub
      if(0 != _testStubIf)
      {
         _testStubIf->destroyStub(objPath, busName, busType);
         removeStub();
      }
      else
      {
         if(0 != _agentStub)
         {
            delete _agentStub;
            _agentStub = 0;
         }
         removeStub();
      }
   }
   else
   {
      ETG_TRACE_USR3((" internalDestroyProxy(): Agent: callbackId=%u busType=%d busName=%20s objPath=%s (already done)", callbackId, busType, busName.c_str(), objPath.c_str()));
   }
}

void EvolutionGeniviDbusAgentStubIf::internalDestroyAllProxies(void)
{
   ETG_TRACE_USR3((" internalDestroyAllProxies(): Agent"));

   // destroy all stubs
   if(0 != _testStubIf)
   {
      _testStubIf->destroyAllStubs();
      removeAllStubs();
   }
   else
   {
      if(0 != _agentStub)
      {
         delete _agentStub;
         _agentStub = 0;
      }
      removeAllStubs();
   }

   // remove callback information
   removeCallbacks();
}

void EvolutionGeniviDbusAgentStubIf::internalDestroyAllRuntimeProxies(void)
{
   ETG_TRACE_USR3((" internalDestroyAllRuntimeProxies(): Agent"));

   // destroy all runtime stubs
   // nothing to do because this is a static stub

   // do not remove callback information
}

void EvolutionGeniviDbusAgentStubIf::processSetCallback(IEvolutionGeniviDbusAgentCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType)
{
   FW_IF_NULL_PTR_RETURN(callbackIf);
   FW_IF_NULL_PTR_RETURN(_controllerClient);
   _controllerClient->pushWorkItem(new SetCallbackWorkItem< IEvolutionGeniviDbusAgentCallbackIf >(this, callbackIf, enableProxy, callbackId, objPath, busName, busType));
}

bool EvolutionGeniviDbusAgentStubIf::isStubAvailable(void) const
{
   return _stubCreated;
}


void EvolutionGeniviDbusAgentStubIf::addStub(void)
{
   _stubCreated = true;
}

void EvolutionGeniviDbusAgentStubIf::removeStub(void)
{
   _stubCreated = false;
}

void EvolutionGeniviDbusAgentStubIf::removeAllStubs(void)
{
   _stubCreated = false;
}

void EvolutionGeniviDbusAgentStubIf::removeCallbacks(void)
{
   _callbackIf = 0;
}

} //evolution
} //ccdbusif
