/**
 * @file EvolutionGeniviDbusAgentManagerFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for AgentManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for AgentManager.
 */

#include "EvolutionGeniviDbusAgentManagerFactory.h"
#include "EvolutionGeniviDbusAgentManagerProxyIf.h"

namespace ccdbusif {

EvolutionGeniviDbusAgentManagerFactory::EvolutionGeniviDbusAgentManagerFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusAgentManagerFactory::~EvolutionGeniviDbusAgentManagerFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusAgentManagerFactory& EvolutionGeniviDbusAgentManagerFactory::getInstance(void)
{
   static EvolutionGeniviDbusAgentManagerFactory factory;
   return factory;
}

IEvolutionGeniviDbusAgentManagerSendRequestIf* EvolutionGeniviDbusAgentManagerFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(NULL != _proxy)
   {
      // already created
   }
   else
   {
      EvolutionGeniviDbusAgentManagerProxyIf* tmp = new EvolutionGeniviDbusAgentManagerProxyIf(client);
      _proxy = tmp;
      _destroyer = tmp;
      _createdLocally = true;
   }

   return _proxy;
}

void EvolutionGeniviDbusAgentManagerFactory::destroyProxy(void)
{
   if((NULL != _proxy) && (true == _createdLocally))
   {
      delete _proxy;
      _proxy = NULL;
      _destroyer = NULL;
   }
}

void EvolutionGeniviDbusAgentManagerFactory::setProxyForTesting(IEvolutionGeniviDbusAgentManagerSendRequestIf* testProxy)
{
   if(NULL != _proxy)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _proxy = testProxy;
      _destroyer = NULL;
      _createdLocally = false;
   }
}

} //ccdbusif
