/**
 * @file EvolutionGeniviDbusAdapterProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for Adapter.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for Adapter.
 */

#include "EvolutionGeniviDbusAdapterProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusAdapterProperties::EvolutionGeniviDbusAdapterProperties() :
DbusProperties("Adapter1"),
//------------------------------------------------------------------------------
//    const ::std::string _propertyAddress;
// '.* _property(.*);' => '_property$1("$1"),'
//------------------------------------------------------------------------------
// properties
_propertyAddress("Address"),
_propertyClass("Class"),
_propertyAlias("Alias"),
_propertyPowered("Powered"),
_propertyDiscoverable("Discoverable"),
_propertyDiscoverableTimeout("DiscoverableTimeout"),
_propertyPairable("Pairable"),
_propertyPairableTimeout("PairableTimeout"),
_propertyDiscovering("Discovering"),
_propertyUUIDs("UUIDs"),
_propertyWBSMode("WBSMode"),
_propertyConnectable("Connectable"),
_propertyHCIMode("HCIMode"),
_propertyVersion("Version"),
_propertyVersionCode("Code"),
_propertyVersionGeniviVersion("GeniviVersion"),
_propertyVersionEvoVersion("EvoVersion"),
_propertyTraceLevel("TraceLevel"),
_propertyTraceCategory("TraceCategory")
{
   //------------------------------------------------------------------------------
   //    const ::std::string _propertyAddress;
   // '   .* _property(.*);' => '   _string2EnumList[_property$1] = (int)ADAPTER_$1;'
   //------------------------------------------------------------------------------
   _string2EnumList[_propertyAddress] = (int)ADAPTER_ADDRESS;
   _string2EnumList[_propertyClass] = (int)ADAPTER_CLASS;
   _string2EnumList[_propertyAlias] = (int)ADAPTER_ALIAS;
   _string2EnumList[_propertyPowered] = (int)ADAPTER_POWERED;
   _string2EnumList[_propertyDiscoverable] = (int)ADAPTER_DISCOVERABLE;
   _string2EnumList[_propertyDiscoverableTimeout] = (int)ADAPTER_DISCOVERABLETIMEOUT;
   _string2EnumList[_propertyPairable] = (int)ADAPTER_PAIRABLE;
   _string2EnumList[_propertyPairableTimeout] = (int)ADAPTER_PAIRABLETIMEOUT;
   _string2EnumList[_propertyDiscovering] = (int)ADAPTER_DISCOVERING;
   _string2EnumList[_propertyUUIDs] = (int)ADAPTER_UUIDS;
   _string2EnumList[_propertyWBSMode] = (int)ADAPTER_WBSMODE;
   _string2EnumList[_propertyConnectable] = (int)ADAPTER_CONNECTABLE;
   _string2EnumList[_propertyHCIMode] = (int)ADAPTER_HCIMODE;
   _string2EnumList[_propertyVersion] = (int)ADAPTER_VERSION;
   _string2EnumList[_propertyVersionCode] = (int)ADAPTER_VERSION_CODE;
   _string2EnumList[_propertyVersionGeniviVersion] = (int)ADAPTER_VERSION_GENIVI_VERSION;
   _string2EnumList[_propertyVersionEvoVersion] = (int)ADAPTER_VERSION_EVO_VERSION;
   _string2EnumList[_propertyTraceLevel] = (int)ADAPTER_TRACELEVEL;
   _string2EnumList[_propertyTraceCategory] = (int)ADAPTER_TRACECATEGORY;

   //------------------------------------------------------------------------------
   //    const ::std::string _propertyAddress;
   // '   .* _property(.*);' => '   _enum2StringList[(int)ADAPTER_$1] = &_property$1;'
   //------------------------------------------------------------------------------
   _enum2StringList[(int)ADAPTER_ADDRESS] = &_propertyAddress;
   _enum2StringList[(int)ADAPTER_CLASS] = &_propertyClass;
   _enum2StringList[(int)ADAPTER_ALIAS] = &_propertyAlias;
   _enum2StringList[(int)ADAPTER_POWERED] = &_propertyPowered;
   _enum2StringList[(int)ADAPTER_DISCOVERABLE] = &_propertyDiscoverable;
   _enum2StringList[(int)ADAPTER_DISCOVERABLETIMEOUT] = &_propertyDiscoverableTimeout;
   _enum2StringList[(int)ADAPTER_PAIRABLE] = &_propertyPairable;
   _enum2StringList[(int)ADAPTER_PAIRABLETIMEOUT] = &_propertyPairableTimeout;
   _enum2StringList[(int)ADAPTER_DISCOVERING] = &_propertyDiscovering;
   _enum2StringList[(int)ADAPTER_UUIDS] = &_propertyUUIDs;
   _enum2StringList[(int)ADAPTER_WBSMODE] = &_propertyWBSMode;
   _enum2StringList[(int)ADAPTER_CONNECTABLE] = &_propertyConnectable;
   _enum2StringList[(int)ADAPTER_HCIMODE] = &_propertyHCIMode;
   _enum2StringList[(int)ADAPTER_VERSION] = &_propertyVersion;
   _enum2StringList[(int)ADAPTER_VERSION_CODE] = &_propertyVersionCode;
   _enum2StringList[(int)ADAPTER_VERSION_GENIVI_VERSION] = &_propertyVersionGeniviVersion;
   _enum2StringList[(int)ADAPTER_VERSION_EVO_VERSION] = &_propertyVersionEvoVersion;
   _enum2StringList[(int)ADAPTER_TRACELEVEL] = &_propertyTraceLevel;
   _enum2StringList[(int)ADAPTER_TRACECATEGORY] = &_propertyTraceCategory;
}

EvolutionGeniviDbusAdapterProperties::~EvolutionGeniviDbusAdapterProperties()
{
}

AdapterProperty EvolutionGeniviDbusAdapterProperties::getProperty2Enum(const ::std::string& value) const
{
   return (AdapterProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusAdapterProperties::getProperty2String(const AdapterProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusAdapterProperties::getProperty2StringTrace(const AdapterProperty value) const
{
   if(ADAPTER_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
