/**
 * @file IEvolutionGeniviDbusPanCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Pan.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Pan.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_PAN_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_PAN_CALLBACK_IF_H_

#include "org/alps/evo/PANProxy.h"

using namespace ::org::alps::evo::PAN;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for Pan.
 */
class IEvolutionGeniviDbusPanCallbackIf :
   // from org/alps/evo/PANProxy.h --- start
   public BtApplPanSendDataReqCallbackIF,
   public BtApplPanFilterNettypeReqCallbackIF,
   public BtApplPanFilterMuladdrReqCallbackIF,
   public BtApplPanSendDataCfmCallbackIF,
   public BtApplPanSendIndCallbackIF,
   public BtApplPanFilterNettypeCfmCallbackIF,
   public BtApplPanFilterNettypeIndCallbackIF,
   public BtApplPanFilterMuladdrCfmCallbackIF,
   public BtApplPanFilterMuladdrIndCallbackIF,
   public BtApplPanDataIndCallbackIF
   // from org/alps/evo/PANProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusPanCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/alps/evo/PANProxy implementation --- start
   virtual void onBtApplPanSendDataReqError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendDataReqError >& error) = 0;

   virtual void onBtApplPanSendDataReqResponse(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendDataReqResponse >& response) = 0;

   virtual void onBtApplPanFilterNettypeReqError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeReqError >& error) = 0;

   virtual void onBtApplPanFilterNettypeReqResponse(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeReqResponse >& response) = 0;

   virtual void onBtApplPanFilterMuladdrReqError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrReqError >& error) = 0;

   virtual void onBtApplPanFilterMuladdrReqResponse(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrReqResponse >& response) = 0;

   virtual void onBtApplPanSendDataCfmError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendDataCfmError >& error) = 0;

   virtual void onBtApplPanSendDataCfmSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendDataCfmSignal >& signal) = 0;

   virtual void onBtApplPanSendIndError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendIndError >& error) = 0;

   virtual void onBtApplPanSendIndSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendIndSignal >& signal) = 0;

   virtual void onBtApplPanFilterNettypeCfmError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeCfmError >& error) = 0;

   virtual void onBtApplPanFilterNettypeCfmSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeCfmSignal >& signal) = 0;

   virtual void onBtApplPanFilterNettypeIndError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeIndError >& error) = 0;

   virtual void onBtApplPanFilterNettypeIndSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeIndSignal >& signal) = 0;

   virtual void onBtApplPanFilterMuladdrCfmError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrCfmError >& error) = 0;

   virtual void onBtApplPanFilterMuladdrCfmSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrCfmSignal >& signal) = 0;

   virtual void onBtApplPanFilterMuladdrIndError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrIndError >& error) = 0;

   virtual void onBtApplPanFilterMuladdrIndSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrIndSignal >& signal) = 0;

   virtual void onBtApplPanDataIndError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanDataIndError >& error) = 0;

   virtual void onBtApplPanDataIndSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanDataIndSignal >& signal) = 0;
   // org/alps/evo/PANProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_PAN_CALLBACK_IF_H_
