/**
 * @file IEvolutionGeniviDbusObexTransferCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for ObexTransfer.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for ObexTransfer.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_CALLBACK_IF_H_

#include "org/bluez/obex/TransferProxy.h"

using namespace ::org::bluez::obex::Transfer;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for ObexTransfer.
 */
class IEvolutionGeniviDbusObexTransferCallbackIf :
   // from org/bluez/obex/TransferProxy.h --- start
   public CancelCallbackIF,
   public StatusCallbackIF,
   public SessionCallbackIF,
   public NameCallbackIF,
   public TypeCallbackIF,
   public TimeCallbackIF,
   public SizeCallbackIF,
   public TransferredCallbackIF,
   public FilenameCallbackIF
   // from org/bluez/obex/TransferProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusObexTransferCallbackIf() {}

   // HINT: these interfaces are called within context of thread defined in CcDbusIfAppLibrary.cma ("ccDbusIfThread")

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/obex/TransferProxy implementation --- start
   virtual void onCancelError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< CancelError >& error) = 0;

   virtual void onCancelResponse(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< CancelResponse >& response) = 0;

   virtual void onStatusError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< StatusError >& error) = 0;

   virtual void onStatusUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< StatusUpdate >& update) = 0;

   virtual void onSessionError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SessionError >& error) = 0;

   virtual void onSessionUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SessionUpdate >& update) = 0;

   virtual void onNameError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< NameError >& error) = 0;

   virtual void onNameUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< NameUpdate >& update) = 0;

   virtual void onTypeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TypeError >& error) = 0;

   virtual void onTypeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TypeUpdate >& update) = 0;

   virtual void onTimeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TimeError >& error) = 0;

   virtual void onTimeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TimeUpdate >& update) = 0;

   virtual void onSizeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SizeError >& error) = 0;

   virtual void onSizeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SizeUpdate >& update) = 0;

   virtual void onTransferredError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TransferredError >& error) = 0;

   virtual void onTransferredUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TransferredUpdate >& update) = 0;

   virtual void onFilenameError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< FilenameError >& error) = 0;

   virtual void onFilenameUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< FilenameUpdate >& update) = 0;
   // org/bluez/obex/TransferProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_CALLBACK_IF_H_
