/**
 * @file IEvolutionGeniviDbusObexSessionCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for ObexSession.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for ObexSession.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_OBEX_SESSION_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_OBEX_SESSION_CALLBACK_IF_H_

#include "org/bluez/obex/SessionProxy.h"

using namespace ::org::bluez::obex::Session;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for ObexSession.
 */
class IEvolutionGeniviDbusObexSessionCallbackIf :
   // from org/bluez/obex/SessionProxy.h --- start
   public SourceCallbackIF,
   public DestinationCallbackIF,
   public ChannelCallbackIF,
   public TargetCallbackIF
   // from org/bluez/obex/SessionProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusObexSessionCallbackIf() {}

   // HINT: these interfaces are called within context of thread defined in CcDbusIfAppLibrary.cma ("ccDbusIfThread")

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/obex/SessionProxy implementation --- start
   virtual void onSourceError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< SourceError >& error) = 0;

   virtual void onSourceUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< SourceUpdate >& update) = 0;

   virtual void onDestinationError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DestinationError >& error) = 0;

   virtual void onDestinationUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DestinationUpdate >& update) = 0;

   virtual void onChannelError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ChannelError >& error) = 0;

   virtual void onChannelUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ChannelUpdate >& update) = 0;

   virtual void onTargetError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< TargetError >& error) = 0;

   virtual void onTargetUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< TargetUpdate >& update) = 0;
   // org/bluez/obex/SessionProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_OBEX_SESSION_CALLBACK_IF_H_
