/**
 * @file IEvolutionGeniviDbusObexClientCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for ObexClient.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for ObexClient.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_CALLBACK_IF_H_

#include "org/bluez/obex/ClientProxy.h"

using namespace ::org::bluez::obex::Client;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for ObexClient.
 */
class IEvolutionGeniviDbusObexClientCallbackIf :
   // from org/bluez/obex/ClientProxy.h --- start
   public CancelSessionCallbackIF,
   public CreateSessionCallbackIF,
   public RemoveSessionCallbackIF,
   public SessionCreatedCallbackIF,
   public SessionRemovedCallbackIF
   // from org/bluez/obex/ClientProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusObexClientCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/obex/ClientProxy implementation --- start
   virtual void onCancelSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CancelSessionError >& error) = 0;

   virtual void onCancelSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CancelSessionResponse >& response) = 0;

   virtual void onCreateSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CreateSessionError >& error) = 0;

   virtual void onCreateSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CreateSessionResponse >& response) = 0;

   virtual void onRemoveSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< RemoveSessionError >& error) = 0;

   virtual void onRemoveSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< RemoveSessionResponse >& response) = 0;

   virtual void onSessionCreatedError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionCreatedError >& error) = 0;

   virtual void onSessionCreatedSignal(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionCreatedSignal >& signal) = 0;

   virtual void onSessionRemovedError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionRemovedError >& error) = 0;

   virtual void onSessionRemovedSignal(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionRemovedSignal >& signal) = 0;
   // org/bluez/obex/ClientProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_CALLBACK_IF_H_
