/**
 * @file IEvolutionGeniviDbusLESeamlessPairingSendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for LESeamlessPairing.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for LESeamlessPairing.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_SEND_REQUEST_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_SEND_REQUEST_IF_H_

#include <stdbool.h> // <cstdbool> is marked with C++11
#include <string>
#include <vector>

#include "asf/core/Types.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusLESeamlessPairingCallbackIf;

/**
 * Send request interface class for LESeamlessPairing.
 */
class IEvolutionGeniviDbusLESeamlessPairingSendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusLESeamlessPairingSendRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusLESeamlessPairingCallbackIf* callbackIf, bool enableProxy) = 0;

   /**
    * Handle signal for created seamlessPairing.
    *
    * @param[in] objPath: object path of created seamlessPairing
    */
   virtual void seamlessPairingCreated(const ::std::string& objPath) = 0;

   /**
    * Handle signal for removed seamlessPairing.
    *
    * @param[in] objPath: object path of removed seamlessPairing
    */
   virtual void seamlessPairingRemoved(const ::std::string& objPath) = 0;

   /**
    * Send SendErrorCode Request.
    *
    * @param[in] objPath: object path of seamlessPairing
    * @param[in] error_code: arguments details
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendSendErrorCodeRequest(const ::std::string& objPath, const ::std::string& error_code) = 0;

   /**
    * Send AllowAccess Request.
    *
    * @param[in] objPath: object path of seamlessPairing
    * @param[in] accept: arguments details
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendAllowAccessRequest(const ::std::string& objPath, bool accept) = 0;

   /**
    * Send PairingData Get.
    *
    * @param[in] objPath: object path of seamlessPairing
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendPairingDataGet(const ::std::string& objPath) = 0;

   /**
    * Send PairingData Set.
    *
    * @param[in] objPath: object path of seamlessPairing
    * @param[in] pairingData: arguments details
    */
   virtual void sendPairingDataSet(const ::std::string& objPath, const ::std::vector< uint8 >& pairingData) = 0;
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_SEND_REQUEST_IF_H_
