/**
 * @file IEvolutionGeniviDbusLESeamlessPairingCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for LESeamlessPairing.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for LESeamlessPairing.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_CALLBACK_IF_H_

#include "org/bluez/SeamlessPairingProxy.h"

using namespace ::org::bluez::SeamlessPairing;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for LESeamlessPairing.
 */
class IEvolutionGeniviDbusLESeamlessPairingCallbackIf :
   // from org/bluez/SeamlessPairingProxy.h --- start
   public SendErrorCodeCallbackIF,
   public AllowAccessCallbackIF,
   public ErrorCodeReceivedCallbackIF,
   public AccessRequestCallbackIF,
   public PairingDataCallbackIF
   // from org/bluez/SeamlessPairingProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusLESeamlessPairingCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/SeamlessPairingProxy implementation --- start
   virtual void onSendErrorCodeError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< SendErrorCodeError >& error) = 0;

   virtual void onSendErrorCodeResponse(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< SendErrorCodeResponse >& response) = 0;

   virtual void onAllowAccessError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AllowAccessError >& error) = 0;

   virtual void onAllowAccessResponse(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AllowAccessResponse >& response) = 0;

   virtual void onErrorCodeReceivedError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< ErrorCodeReceivedError >& error) = 0;

   virtual void onErrorCodeReceivedSignal(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< ErrorCodeReceivedSignal >& signal) = 0;

   virtual void onAccessRequestError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AccessRequestError >& error) = 0;

   virtual void onAccessRequestSignal(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AccessRequestSignal >& signal) = 0;

   virtual void onPairingDataError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< PairingDataError >& error) = 0;

   virtual void onPairingDataUpdate(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< PairingDataUpdate >& update) = 0;
   // org/bluez/SeamlessPairingProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_CALLBACK_IF_H_
