/**
 * @file IEvolutionGeniviDbusLEDeviceCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for LEDevice.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for LEDevice.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_LE_DEVICE_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_LE_DEVICE_CALLBACK_IF_H_

#include "org/bluez/LE_Device1Proxy.h"

using namespace ::org::bluez::LE_Device1;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for LEDevice.
 */
class IEvolutionGeniviDbusLEDeviceCallbackIf :
   // from org/bluez/LE_Device1Proxy.h --- start
   public DisconnectCallbackIF,
   public DisconnectionCompCallbackIF,
   public AddressTypeCallbackIF,
   public AddressCallbackIF,
   public ConnectedCallbackIF
   // from org/bluez/LE_Device1Proxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusLEDeviceCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/LE_Device1Proxy implementation --- start
   virtual void onDisconnectError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error) = 0;

   virtual void onDisconnectResponse(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response) = 0;

   virtual void onDisconnectionCompError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectionCompError >& error) = 0;

   virtual void onDisconnectionCompSignal(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectionCompSignal >& signal) = 0;

   virtual void onAddressTypeError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeError >& error) = 0;

   virtual void onAddressTypeUpdate(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeUpdate >& update) = 0;

   virtual void onAddressError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressError >& error) = 0;

   virtual void onAddressUpdate(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressUpdate >& update) = 0;

   virtual void onConnectedError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedError >& error) = 0;

   virtual void onConnectedUpdate(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedUpdate >& update) = 0;
   // org/bluez/LE_Device1Proxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_LE_DEVICE_CALLBACK_IF_H_
