/**
 * @file IEvolutionGeniviDbusLEAdapterCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for LEAdapter.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for LEAdapter.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_LE_ADAPTER_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_LE_ADAPTER_CALLBACK_IF_H_

#include "org/bluez/LE_Adapter1Proxy.h"

using namespace ::org::bluez::LE_Adapter1;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for LEAdapter.
 */
class IEvolutionGeniviDbusLEAdapterCallbackIf :
   // from org/bluez/LE_Adapter1Proxy.h --- start
   public CreateLeDeviceCallbackIF,
   public RemoveLeDeviceCallbackIF,
   public LeAdapterInitializationCallbackIF,
   public LeDeviceCreatedCallbackIF,
   public LeDeviceRemovedCallbackIF,
   public AddressTypeCallbackIF,
   public AddressCallbackIF,
   public AliasCallbackIF,
   public AdvertisingTimeoutCallbackIF,
   public DiscoverableModeCallbackIF,
   public AdvertisingDataCallbackIF,
   public AdvertiseEnableCallbackIF
   // from org/bluez/LE_Adapter1Proxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusLEAdapterCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/LE_Adapter1Proxy implementation --- start
   virtual void onCreateLeDeviceError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< CreateLeDeviceError >& error) = 0;

   virtual void onCreateLeDeviceResponse(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< CreateLeDeviceResponse >& response) = 0;

   virtual void onRemoveLeDeviceError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< RemoveLeDeviceError >& error) = 0;

   virtual void onRemoveLeDeviceResponse(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< RemoveLeDeviceResponse >& response) = 0;

   virtual void onLeAdapterInitializationError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeAdapterInitializationError >& error) = 0;

   virtual void onLeAdapterInitializationSignal(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeAdapterInitializationSignal >& signal) = 0;

   virtual void onLeDeviceCreatedError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceCreatedError >& error) = 0;

   virtual void onLeDeviceCreatedSignal(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceCreatedSignal >& signal) = 0;

   virtual void onLeDeviceRemovedError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceRemovedError >& error) = 0;

   virtual void onLeDeviceRemovedSignal(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceRemovedSignal >& signal) = 0;

   virtual void onAddressTypeError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeError >& error) = 0;

   virtual void onAddressTypeUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeUpdate >& update) = 0;

   virtual void onAddressError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressError >& error) = 0;

   virtual void onAddressUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressUpdate >& update) = 0;

   virtual void onAliasError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AliasError >& error) = 0;

   virtual void onAliasUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AliasUpdate >& update) = 0;

   virtual void onAdvertisingTimeoutError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingTimeoutError >& error) = 0;

   virtual void onAdvertisingTimeoutUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingTimeoutUpdate >& update) = 0;

   virtual void onDiscoverableModeError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableModeError >& error) = 0;

   virtual void onDiscoverableModeUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableModeUpdate >& update) = 0;

   virtual void onAdvertisingDataError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingDataError >& error) = 0;

   virtual void onAdvertisingDataUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingDataUpdate >& update) = 0;

   virtual void onAdvertiseEnableError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertiseEnableError >& error) = 0;

   virtual void onAdvertiseEnableUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertiseEnableUpdate >& update) = 0;
   // org/bluez/LE_Adapter1Proxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_LE_ADAPTER_CALLBACK_IF_H_
