/**
 * @file IEvolutionGeniviDbusHfpNetworkOperatorSendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Send Request Interface for HfpNetworkOperator.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS send request for HfpNetworkOperator.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_SEND_REQUEST_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_SEND_REQUEST_IF_H_

#include <stdbool.h> // <cstdbool> is marked with C++11
#include <string>

#include "asf/core/Types.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusHfpNetworkOperatorCallbackIf;

/**
 * Send request interface class for HfpNetworkOperator.
 */
class IEvolutionGeniviDbusHfpNetworkOperatorSendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusHfpNetworkOperatorSendRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpNetworkOperatorCallbackIf* callbackIf, bool enableProxy) = 0;

   /**
    * Handle signal for created operator.
    *
    * @param[in] objPath: object path of created operator
    */
   virtual void operatorCreated(const ::std::string& objPath) = 0;

   /**
    * Handle signal for removed operator.
    *
    * @param[in] objPath: object path of removed operator
    */
   virtual void operatorRemoved(const ::std::string& objPath) = 0;

   /**
    * Send GetProperties Request.
    *
    * @param[in] objPath: object path of operator
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) = 0;
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_SEND_REQUEST_IF_H_
