/**
 * @file IEvolutionGeniviDbusHfpNetworkOperatorCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpNetworkOperator.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for HfpNetworkOperator.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_CALLBACK_IF_H_

#include "org/ofono/NetworkOperatorProxy.h"

using namespace ::org::ofono::NetworkOperator;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for HfpNetworkOperator.
 */
class IEvolutionGeniviDbusHfpNetworkOperatorCallbackIf :
   // from org/ofono/NetworkOperatorProxy.h --- start
   public GetPropertiesCallbackIF,
   public PropertyChangedCallbackIF
   // from org/ofono/NetworkOperatorProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusHfpNetworkOperatorCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/NetworkOperatorProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;

   virtual void onPropertyChangedError(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
   // org/ofono/NetworkOperatorProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_CALLBACK_IF_H_
