/**
 * @file IEvolutionGeniviDbusHfpManagerSendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Send Request Interface for HfpManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS send request for HfpManager.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_HFP_MANAGER_SEND_REQUEST_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_HFP_MANAGER_SEND_REQUEST_IF_H_

#include <stdbool.h> // <cstdbool> is marked with C++11

#include "asf/core/Types.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusHfpManagerCallbackIf;

/**
 * Send request interface class for HfpManager.
 */
class IEvolutionGeniviDbusHfpManagerSendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusHfpManagerSendRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpManagerCallbackIf* callbackIf, bool enableProxy) = 0;

   /**
    * Send GetModems Request.
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendGetModemsRequest(void) = 0;
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_HFP_MANAGER_SEND_REQUEST_IF_H_
