/**
 * @file IEvolutionGeniviDbusHandleDeviceIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Proxy: handle device created / removed signal.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_HANDLE_DEVICE_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_HANDLE_DEVICE_IF_H_

#include <string>

namespace ccdbusif {

/**
 *
 */
class IEvolutionGeniviDbusHandleDeviceIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusHandleDeviceIf() {}

   /**
    * Handle created device.
    *
    * @param[in] objPath: object path
    */
   virtual void handleDeviceCreated(const ::std::string& objPath) = 0;

   /**
    * Handle removed device.
    *
    * @param[in] objPath: object path
    */
   virtual void handleDeviceRemoved(const ::std::string& objPath) = 0;
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_HANDLE_DEVICE_IF_H_
