/**
 * @file IEvolutionGeniviDbusDunSendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Send Request Interface for Dun.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS send request for Dun.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_DUN_SEND_REQUEST_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_DUN_SEND_REQUEST_IF_H_

#include <stdbool.h> // <cstdbool> is marked with C++11
#include <vector>

#include "asf/core/Types.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusDunCallbackIf;

/**
 * Send request interface class for Dun.
 */
class IEvolutionGeniviDbusDunSendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusDunSendRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusDunCallbackIf* callbackIf, bool enableProxy) = 0;

   /**
    * Send BtApplDunSendDataReq Request.
    * Request to send outgoing data to the remote device via the DUN service
    *
    * @param[in] data - Data to transmit
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendBtApplDunSendDataReqRequest(const ::std::vector< uint8 >& data) = 0;

   /**
    * Send BtApplDunFlowCtrlReq Request.
    * Host can stop data transfer by sending this message with parameter stop to module and with parameter go to resume data transfer
    * in case that host is ready to receive data.
    *
    * @param[in] action - 0x00 – go, 0x01 – stop
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendBtApplDunFlowCtrlReqRequest(uint8 action) = 0;
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_DUN_SEND_REQUEST_IF_H_
