/**
 * @file IEvolutionGeniviDbusDidSendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Send Request Interface for Did.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS send request for Did.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_DID_SEND_REQUEST_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_DID_SEND_REQUEST_IF_H_

#include <stdbool.h> // <cstdbool> is marked with C++11
#include <vector>

#include "asf/core/Types.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusDidCallbackIf;

/**
 * Send request interface class for Did.
 */
class IEvolutionGeniviDbusDidSendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusDidSendRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusDidCallbackIf* callbackIf, bool enableProxy) = 0;

   /**
    * Send BtApplDidSetReq Request.
    * This method is used to set a local Device ID Service Record, with which module will reply to external SDP-request.
    * There should be only one primary record. If a primary record is already defined but this PrimaryRecord attribute
    * is set to TRUE, the current set-request will fail.
    *
    * Possible Errors:
    *    org.bluez.Error InvalidArguments
    *    org.bluez.Error.Failed
    *
    * @param[in] entry - Index of local record to set,Range:0x00-0x03
    * @param[in] record - Record data (Length of record data in Range:0x0000-0x013D)
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendBtApplDidSetReqRequest(uint8 entry, const ::std::vector< uint8 >& record) = 0;
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_DID_SEND_REQUEST_IF_H_
